/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.id;

class Relation {
    Accessible accessible;
    Accessible[] targets;
    int type;

    Relation(Accessible accessible, int type2) {
        this.accessible = accessible;
        this.type = type2;
        this.targets = new Accessible[0];
    }

    void addTarget(Accessible target) {
        if (this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, newTargets, 0, this.targets.length);
        newTargets[this.targets.length] = target;
        this.targets = newTargets;
    }

    boolean containsTarget(Accessible target) {
        int i2 = 0;
        while (i2 < this.targets.length) {
            if (this.targets[i2] == target) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    void removeTarget(Accessible target) {
        if (!this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length - 1];
        int j = 0;
        int i2 = 0;
        while (i2 < this.targets.length) {
            if (this.targets[i2] != target) {
                newTargets[j++] = this.targets[i2];
            }
            ++i2;
        }
        this.targets = newTargets;
    }

    id getTitleUIElement() {
        id result2 = null;
        int i2 = 0;
        while (i2 < this.targets.length) {
            Accessible target = this.targets[i2];
            result2 = target.accessibleHandle(target);
            ++i2;
        }
        return result2;
    }

    id getServesAsTitleForUIElements() {
        NSMutableArray result2 = NSMutableArray.arrayWithCapacity(this.targets.length);
        int i2 = 0;
        while (i2 < this.targets.length) {
            Accessible target = this.targets[i2];
            id accessibleElement = target.accessibleHandle(target);
            result2.addObject(accessibleElement);
            ++i2;
        }
        return result2;
    }

    id getLinkedUIElements() {
        NSMutableArray result2 = NSMutableArray.arrayWithCapacity(this.targets.length);
        int i2 = 0;
        while (i2 < this.targets.length) {
            Accessible target = this.targets[i2];
            id accessibleElement = target.accessibleHandle(target);
            result2.addObject(accessibleElement);
            ++i2;
        }
        return result2;
    }
}

