/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CommonDialogs {
    private CommonDialogs() {
    }

    public static FileChooserResult showFileChooser(Window window, File file, String string2, String string3, int n, boolean bl, List<ExtensionFilter> list2, int n2) {
        Application.checkEventThread();
        String string4 = CommonDialogs.convertFolder(file);
        if (string2 == null) {
            string2 = "";
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Type parameter must be equal to one of the constants from Type");
        }
        ExtensionFilter[] extensionFilterArray = null;
        if (list2 != null) {
            extensionFilterArray = list2.toArray(new ExtensionFilter[list2.size()]);
        }
        if (list2 == null || list2.isEmpty() || n2 < 0 || n2 >= list2.size()) {
            n2 = 0;
        }
        return Application.GetApplication().staticCommonDialogs_showFileChooser(window, string4, string2, CommonDialogs.convertTitle(string3), n, bl, extensionFilterArray, n2);
    }

    public static File showFolderChooser(Window window, File file, String string2) {
        Application.checkEventThread();
        return Application.GetApplication().staticCommonDialogs_showFolderChooser(window, CommonDialogs.convertFolder(file), CommonDialogs.convertTitle(string2));
    }

    private static String convertFolder(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Unable to get a canonical path for folder", iOException);
                }
            }
            throw new IllegalArgumentException("Folder parameter must be a valid folder");
        }
        return "";
    }

    private static String convertTitle(String string2) {
        return string2 != null ? string2 : "";
    }

    protected static FileChooserResult createFileChooserResult(String[] stringArray, ExtensionFilter[] extensionFilterArray, int n) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : stringArray) {
            if (string2 == null) continue;
            arrayList.add(new File(string2));
        }
        return new FileChooserResult(arrayList, extensionFilterArray == null || n < 0 || n >= extensionFilterArray.length ? null : extensionFilterArray[n]);
    }

    public static final class FileChooserResult {
        private final List<File> files;
        private final ExtensionFilter filter;

        public FileChooserResult(List<File> list2, ExtensionFilter extensionFilter) {
            if (list2 == null) {
                throw new NullPointerException("files should not be null");
            }
            this.files = list2;
            this.filter = extensionFilter;
        }

        public FileChooserResult() {
            this(new ArrayList<File>(), null);
        }

        public List<File> getFiles() {
            return this.files;
        }

        public ExtensionFilter getExtensionFilter() {
            return this.filter;
        }
    }

    public static final class ExtensionFilter {
        private final String description;
        private final List<String> extensions;

        public ExtensionFilter(String string2, List<String> list2) {
            Application.checkEventThread();
            if (string2 == null || string2.trim().isEmpty()) {
                throw new IllegalArgumentException("Description parameter must be non-null and not empty");
            }
            if (list2 == null || list2.isEmpty()) {
                throw new IllegalArgumentException("Extensions parameter must be non-null and not empty");
            }
            for (String string3 : list2) {
                if (string3 != null && string3.length() != 0) continue;
                throw new IllegalArgumentException("Each extension must be non-null and not empty");
            }
            this.description = string2;
            this.extensions = list2;
        }

        public String getDescription() {
            Application.checkEventThread();
            return this.description;
        }

        public List<String> getExtensions() {
            Application.checkEventThread();
            return this.extensions;
        }

        private String[] extensionsToArray() {
            Application.checkEventThread();
            return this.extensions.toArray(new String[this.extensions.size()]);
        }
    }

    public static final class Type {
        public static final int OPEN = 0;
        public static final int SAVE = 1;
    }
}

