/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.CalculatedValue;
import com.sun.javafx.css.PseudoClassState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.scene.text.Font;

public final class StyleCacheEntry {
    private Map<String, CalculatedValue> calculatedValues;

    public CalculatedValue get(String string2) {
        CalculatedValue calculatedValue = null;
        if (this.calculatedValues != null && !this.calculatedValues.isEmpty()) {
            calculatedValue = this.calculatedValues.get(string2);
        }
        return calculatedValue;
    }

    public void put(String string2, CalculatedValue calculatedValue) {
        if (this.calculatedValues == null) {
            this.calculatedValues = new HashMap<String, CalculatedValue>(5);
        }
        this.calculatedValues.put(string2, calculatedValue);
    }

    public static final class Key {
        private final Set<PseudoClass>[] pseudoClassStates;
        private final double fontSize;
        private int hash = Integer.MIN_VALUE;

        public Key(Set<PseudoClass>[] setArray, Font font) {
            this.pseudoClassStates = new Set[setArray.length];
            for (int j = 0; j < setArray.length; ++j) {
                this.pseudoClassStates[j] = new PseudoClassState();
                this.pseudoClassStates[j].addAll(setArray[j]);
            }
            this.fontSize = font != null ? font.getSize() : Font.getDefault().getSize();
        }

        public String toString() {
            return Arrays.toString(this.pseudoClassStates) + ", " + this.fontSize;
        }

        public static int hashCode(double d) {
            long l = Double.doubleToLongBits(d);
            return (int)(l ^ l >>> 32);
        }

        public int hashCode() {
            if (this.hash == Integer.MIN_VALUE) {
                this.hash = Key.hashCode(this.fontSize);
                int n = this.pseudoClassStates != null ? this.pseudoClassStates.length : 0;
                for (int j = 0; j < n; ++j) {
                    Set<PseudoClass> set2 = this.pseudoClassStates[j];
                    if (set2 == null) continue;
                    this.hash = 67 * (this.hash + set2.hashCode());
                }
            }
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            Key key2 = (Key)object;
            if (this.hash != key2.hash) {
                return false;
            }
            double d = this.fontSize - key2.fontSize;
            if (d < -1.0E-6 || 1.0E-6 < d) {
                return false;
            }
            if (this.pseudoClassStates == null ^ key2.pseudoClassStates == null) {
                return false;
            }
            if (this.pseudoClassStates == null) {
                return true;
            }
            if (this.pseudoClassStates.length != key2.pseudoClassStates.length) {
                return false;
            }
            for (int j = 0; j < this.pseudoClassStates.length; ++j) {
                Set<PseudoClass> set2 = this.pseudoClassStates[j];
                Set<PseudoClass> set3 = key2.pseudoClassStates[j];
                if (!(set2 == null ? set3 != null : !set2.equals(set3))) continue;
                return false;
            }
            return true;
        }
    }
}

