/*
 * Decompiled with CFR 0.152.
 */
package gde.device.weatronic;

import gde.GDE;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.weatronic.WeatronicAdapterDialog;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.MeasurementControl;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WeatronicAdapterDialogTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(WeatronicAdapterDialogTabItem.class.getName());
    Composite measurementComposite;
    Button measurement;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    Label tabItemLabel;
    ScrolledComposite scolledComposite;
    Composite mainTabComposite;
    final CTabFolder parent;
    final IDevice device;
    final DataExplorer application;
    final Channels channels;
    final WeatronicAdapterDialog dialog;
    final int channelConfigNumber;
    final List<MeasurementControl> measurementControls = new ArrayList<MeasurementControl>();

    public WeatronicAdapterDialogTabItem(CTabFolder parentTabFolder, WeatronicAdapterDialog parentDialog, int useChannelConfigNumber, IDevice useDevice) {
        super(parentTabFolder, 0);
        this.parent = parentTabFolder;
        this.dialog = parentDialog;
        this.device = useDevice;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.channelConfigNumber = useChannelConfigNumber;
        this.setText(this.device.getChannelNameReplacement(this.channelConfigNumber));
        this.create();
    }

    void create() {
        this.scolledComposite = new ScrolledComposite((Composite)this.parent, 512);
        this.scolledComposite.setLayout((Layout)new FillLayout());
        this.setControl((Control)this.scolledComposite);
        this.mainTabComposite = new Composite((Composite)this.scolledComposite, 0);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        mainTabCompositeLayout.numColumns = 2;
        this.mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        this.mainTabComposite.setSize(610, 350);
        this.scolledComposite.setContent((Control)this.mainTabComposite);
        this.tabItemLabel = new Label(this.mainTabComposite, 0x1000000);
        GridData tabItemLabelLData = new GridData();
        tabItemLabelLData.horizontalAlignment = 1;
        tabItemLabelLData.verticalAlignment = 1;
        tabItemLabelLData.heightHint = 20;
        tabItemLabelLData.widthHint = 300;
        this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
        this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
        this.tabItemLabel.setText(Messages.getString((String)"GDE_MSGT3709"));
        Composite filler = new Composite(this.mainTabComposite, 0);
        GridData fillerLData = new GridData();
        fillerLData.horizontalAlignment = 1;
        fillerLData.verticalAlignment = 1;
        fillerLData.heightHint = 20;
        fillerLData.widthHint = 300;
        filler.setLayoutData((Object)fillerLData);
        List measurementTypes = this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber);
        for (int i = 0; i < this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).size(); ++i) {
            this.measurementControls.add(new MeasurementControl(this.mainTabComposite, (DeviceDialog)this.dialog, this.channelConfigNumber, i, (MeasurementType)measurementTypes.get(i), this.device, 1));
        }
        this.scolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent evt) {
                log.log(Level.FINEST, "scolledComposite.controlResized, event=" + String.valueOf(evt));
                int height = 35 + WeatronicAdapterDialogTabItem.this.device.getChannelMeasuremtsReplacedNames(WeatronicAdapterDialogTabItem.this.parent.getSelectionIndex() + 1).size() * 28 / 2;
                WeatronicAdapterDialogTabItem.this.mainTabComposite.setSize(WeatronicAdapterDialogTabItem.this.scolledComposite.getClientArea().width, height);
            }

            public void controlMoved(ControlEvent evt) {
                log.log(Level.FINEST, "scolledComposite.controlMoved, event=" + String.valueOf(evt));
                int height = 35 + WeatronicAdapterDialogTabItem.this.device.getChannelMeasuremtsReplacedNames(WeatronicAdapterDialogTabItem.this.parent.getSelectionIndex() + 1).size() * 28 / 2;
                WeatronicAdapterDialogTabItem.this.mainTabComposite.setSize(WeatronicAdapterDialogTabItem.this.scolledComposite.getClientArea().width, height);
            }
        });
    }
}

