/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.GDE;
import gde.config.Settings;
import gde.data.AbstractRecord;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataBlockType;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.wb.CSV2SerialAdapterDialog;
import gde.device.wb.CSV2SerialPort;
import gde.device.wb.GathererThread;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.io.CSVSerialDataReaderWriter;
import gde.io.DataParser;
import gde.io.FileHandler;
import gde.io.IDataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CSV2SerialAdapter
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(CSV2SerialAdapter.class.getName());
    final DataExplorer application;
    final CSV2SerialAdapterDialog dialog;
    protected final CSV2SerialPort serialPort;
    protected final Channels channels;
    protected GathererThread gathererThread;
    protected boolean isFileIO = false;
    protected boolean isSerialIO = false;

    public CSV2SerialAdapter(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.wb.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.dialog = new CSV2SerialAdapterDialog(this.application.getShell(), this);
        this.serialPort = new CSV2SerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1706"), Messages.getString((String)"GDE_MSGT1705"));
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1703"), Messages.getString((String)"GDE_MSGT1703"));
            }
            if (this.isFileIO) {
                this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            }
        }
    }

    public CSV2SerialAdapter(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.wb.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.dialog = new CSV2SerialAdapterDialog(this.application.getShell(), this);
        this.serialPort = new CSV2SerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1706"), Messages.getString((String)"GDE_MSGT1705"));
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1703"), Messages.getString((String)"GDE_MSGT1703"));
            }
            if (this.isFileIO) {
                this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            }
        }
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 69;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        block5: {
            DataParser data = new DataParser(this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)));
            int[] startLength = new int[]{0, 0};
            byte[] lineBuffer = null;
            String sThreadId = String.format("%06d", Thread.currentThread().getId());
            int progressCycle = 0;
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            try {
                for (int i = 0; i < recordDataSize; ++i) {
                    this.setDataLineStartAndLength(dataBuffer, startLength);
                    lineBuffer = new byte[startLength[1]];
                    System.arraycopy(dataBuffer, startLength[0], lineBuffer, 0, startLength[1]);
                    data.parse(new String(lineBuffer), i);
                    recordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                    if (!doUpdateProgressBar || i % 50 != 0) continue;
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                this.updateVisibilityStatus(recordSet, true);
                if (doUpdateProgressBar) {
                    this.application.setProgress(100, sThreadId);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage() + Messages.getString((String)"GDE_MSGW0543");
                log.log(Level.WARNING, msg, e);
                this.application.openMessageDialog(msg);
                if (!doUpdateProgressBar) break block5;
                this.application.setProgress(0, sThreadId);
            }
        }
    }

    private void setDataLineStartAndLength(byte[] dataBuffer, int[] refStartLength) {
        int crlfPos;
        int startPos;
        for (startPos = refStartLength[0] + refStartLength[1]; startPos < dataBuffer.length && (dataBuffer[startPos] != 36 || dataBuffer[startPos + 2] != 49 && dataBuffer[startPos + 3] != 49); ++startPos) {
        }
        for (crlfPos = refStartLength[0] = startPos; crlfPos < dataBuffer.length && (dataBuffer[crlfPos] != 13 || dataBuffer[crlfPos + 1] != 10); ++crlfPos) {
        }
        refStartLength[1] = crlfPos - startPos;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        int timeStampBufferSize = 0;
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getDataType() == Record.DataType.GPS_LATITUDE || record.getDataType() == Record.DataType.GPS_LONGITUDE;
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                switch (record.getDataType()) {
                    case DATE_TIME: {
                        dataTableRow[index + 1] = StringHelper.getFormatedTime((String)record.getUnit(), (long)record.realGet(rowIndex).intValue());
                        dataTableRow[index + 1] = dataTableRow[index + 1].substring(0, dataTableRow[index + 1].indexOf(44) + 2);
                        break;
                    }
                    default: {
                        dataTableRow[index + 1] = record.getFormattedTableValue(rowIndex);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            log.log(Level.FINE, record.getName() + " = " + measurementNames[i]);
            if (record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                log.log(Level.FINE, record.getName() + " ! hasReasonableData ");
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            log.log(Level.FINE, "add to displayable counter: " + record.getName());
            ++displayableCounter;
        }
        log.log(Level.TIME, "displayableCounter = " + displayableCounter);
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        String[] recordNames = recordSet.getRecordNames();
        block3: for (int i = 0; i < recordNames.length; ++i) {
            MeasurementType measurement = this.getMeasurement(recordSet.getChannelConfigNumber(), i);
            PropertyType dataTypeProperty = measurement.getProperty(MeasurementPropertyTypes.DATA_TYPE.value());
            if (dataTypeProperty == null) continue;
            switch (Record.DataType.fromValue((String)dataTypeProperty.getValue())) {
                case DATE_TIME: 
                case GPS_LATITUDE: 
                case GPS_LONGITUDE: 
                case GPS_ALTITUDE: {
                    recordSet.get((Object)recordNames[i]).setDataType(Record.DataType.fromValue((String)dataTypeProperty.getValue()));
                    continue block3;
                }
            }
        }
        this.application.updateStatisticsData();
    }

    public CSV2SerialAdapterDialog getDialog() {
        return this.dialog;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        block14: {
            if (this.isSerialIO) {
                if (this.serialPort != null) {
                    if (!this.serialPort.isConnected()) {
                        try {
                            Channel activChannel = Channels.getInstance().getActiveChannel();
                            if (activChannel == null) break block14;
                            this.gathererThread = new GathererThread(this.application, this, this.serialPort, activChannel.getNumber());
                            try {
                                if (this.serialPort.isConnected()) {
                                    this.gathererThread.start();
                                }
                            }
                            catch (RuntimeException e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                            catch (Throwable e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        catch (SerialPortException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        }
                        catch (ApplicationConfigurationException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                            this.application.getDeviceSelectionDialog().open();
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    } else {
                        if (this.gathererThread != null) {
                            this.gathererThread.stopDataGatheringThread(false, null);
                        }
                        this.serialPort.close();
                    }
                }
            } else {
                this.importCsvFiles();
            }
        }
    }

    public void importCsvFiles() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT1700"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CSV2SerialAdapter.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            String recordNameExtend;
                            try {
                                recordNameExtend = selectedImportFile.substring(selectedImportFile.lastIndexOf(46) - 4, selectedImportFile.lastIndexOf(46));
                                Integer.valueOf(recordNameExtend);
                            }
                            catch (Exception e) {
                                try {
                                    recordNameExtend = selectedImportFile.substring(selectedImportFile.lastIndexOf(46) - 3, selectedImportFile.lastIndexOf(46));
                                    Integer.valueOf(recordNameExtend);
                                }
                                catch (Exception e1) {
                                    recordNameExtend = "";
                                }
                            }
                            Integer channelConfigNumber = CSV2SerialAdapter.this.dialog != null && !CSV2SerialAdapter.this.dialog.isDisposed() ? Integer.valueOf(CSV2SerialAdapter.this.dialog.getTabFolderSelectionIndex() + 1) : null;
                            CSVSerialDataReaderWriter.read((String)selectedImportFile, (IDevice)CSV2SerialAdapter.this, (String)recordNameExtend, (Integer)channelConfigNumber, (IDataParser)new DataParser(CSV2SerialAdapter.this.getDataBlockTimeUnitFactor(), CSV2SerialAdapter.this.getDataBlockLeader(), CSV2SerialAdapter.this.getDataBlockSeparator().value(), CSV2SerialAdapter.this.getDataBlockCheckSumType(), CSV2SerialAdapter.this.getDataBlockSize(InputTypes.FILE_IO)));
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    CSV2SerialAdapter.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT1704", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT1704"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    if (!CSV2SerialAdapter.this.isSerialIO) {
                        CSV2SerialAdapter.this.open_closeCommPort();
                    } else {
                        CSV2SerialAdapter.this.importCsvFiles();
                    }
                }
            });
        }
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordNames = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (recordNames.length - fileRecordsProperties.length > 0) {
            for (String recordProps : fileRecordsProperties) {
                cleanedRecordNames.add((String)StringHelper.splitString((String)recordProps, (String)"|-|", (String[])Record.propertyKeys).get(Record.propertyKeys[0]));
            }
            recordNames = cleanedRecordNames.toArray(new String[1]);
            recordSet.clear();
            for (int j = 0; j < recordNames.length; ++j) {
                MeasurementType measurement = this.getMeasurement(recordSet.getChannelConfigNumber(), j);
                recordSet.addRecordName(recordNames[j]);
                recordSet.put(recordNames[j], (AbstractRecord)new Record((IDevice)this, j, recordNames[j], measurement.getSymbol(), measurement.getUnit(), measurement.isActive(), measurement.getStatistics(), measurement.getProperty(), 5));
            }
        }
        return recordNames;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            exportFileName = new FileHandler().exportFileKMZ(activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_ALTITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_SPEED), activeRecordSet.findRecordOrdinalByUnit(new String[]{"m/s"}), activeRecordSet.findRecordOrdinalByUnit(new String[]{"km"}), -1, true, isExportTmpDir);
        }
        return exportFileName;
    }

    public void export2KMZ3D(int type) {
        RecordSet activeRecordSet;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && activeRecordSet.containsGPSdata()) {
            new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT1710"), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_ALTITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_SPEED), activeRecordSet.findRecordOrdinalByUnit(new String[]{"m/s"}), activeRecordSet.findRecordOrdinalByUnit(new String[]{"km"}), -1, type == 0, type == 2);
        }
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && !(containsGPSdata = activeRecordSet.containsGPSdata())) {
            containsGPSdata = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE) >= 0 && activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE) >= 0;
        }
        return containsGPSdata;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        RecordSet activeRecordSet;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && this.isActualRecordSetWithGpsData()) {
            int recordOrdinal = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_SPEED);
            return recordOrdinal >= 0 ? recordOrdinal : activeRecordSet.findRecordOrdinalByUnit(new String[]{"km/h", "kph"});
        }
        return -1;
    }

    public void updateFileMenu(final Menu exportMenue) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
                    new MenuItem(exportMenue, 2);
                    MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
                    convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT1711"));
                    convertKMZ3DRelativeItem.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            log.log(java.util.logging.Level.FINEST, "convertKLM3DRelativeItem action performed! " + String.valueOf(e));
                            CSV2SerialAdapter.this.export2KMZ3D(0);
                        }
                    });
                    MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
                    convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1712"));
                    convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                            CSV2SerialAdapter.this.export2KMZ3D(1);
                        }
                    });
                    convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
                    convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1713"));
                    convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                            CSV2SerialAdapter.this.export2KMZ3D(2);
                        }
                    });
                }
            }
        });
    }
}

