/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader;

import com.monstarmike.tlmreader.Flight;
import com.monstarmike.tlmreader.IFlight;
import com.monstarmike.tlmreader.TLMReader;
import com.monstarmike.tlmreader.datablock.AirspeedBlock;
import com.monstarmike.tlmreader.datablock.AltitudeBlock;
import com.monstarmike.tlmreader.datablock.AltitudeZeroBlock;
import com.monstarmike.tlmreader.datablock.CurrentBlock;
import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.EscBlock;
import com.monstarmike.tlmreader.datablock.FlightPackBlock;
import com.monstarmike.tlmreader.datablock.GForceBlock;
import com.monstarmike.tlmreader.datablock.GPSCollectorBlock;
import com.monstarmike.tlmreader.datablock.GPSLocationBlock;
import com.monstarmike.tlmreader.datablock.GPSStatusBlock;
import com.monstarmike.tlmreader.datablock.JetCatBlock;
import com.monstarmike.tlmreader.datablock.PowerBoxBlock;
import com.monstarmike.tlmreader.datablock.RxBlock;
import com.monstarmike.tlmreader.datablock.ServoDataBlock;
import com.monstarmike.tlmreader.datablock.StandardBlock;
import com.monstarmike.tlmreader.datablock.TemperatureBlock;
import com.monstarmike.tlmreader.datablock.VarioBlock;
import com.monstarmike.tlmreader.datablock.VoltageBlock;
import java.io.IOException;
import java.util.List;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class App {
    public static void main(String[] args) {
        TLMReader reader = new TLMReader();
        try {
            IFlight flight2;
            String tlmFileHeli;
            long start = System.currentTimeMillis();
            String tlmFileSailplane = "src/test/data/2015-FSS2-day2.TLM";
            String tlm = tlmFileHeli = "src/test/data/2015-12-22_HELI.TLM";
            List<IFlight> flights = reader.parseFlightDefinitions(tlm);
            for (IFlight flight2 : flights) {
                App.printFlightDefinitions(flight2);
            }
            flight2 = reader.parseFlight(tlm, flights.size() - 1);
            ((Flight)flight2).removeRedundantDataBlocks();
            App.printFlightDefinitions(flight2);
            App.printDataBlocks((Flight)flight2);
            long end = System.currentTimeMillis();
            System.out.println("duration: " + (end - start) + " ms");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printFlightDefinitions(IFlight flight) {
        System.out.println("FlightHeader; duration in millis: " + flight.getDuration_ms() + ", expectedNumberOfBlocks: " + flight.getNumberOfDataBlocks());
    }

    private static void printDataBlocks(Flight flight) {
        for (DataBlock dataBlock : flight.getDataBlocks()) {
            if (dataBlock instanceof StandardBlock) {
                System.out.println(((StandardBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof RxBlock) {
                System.out.println(((RxBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof VarioBlock) {
                System.out.println(((VarioBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof AltitudeBlock) {
                System.out.println(((AltitudeBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof AltitudeZeroBlock) {
                System.out.println(((AltitudeZeroBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof VoltageBlock) {
                System.out.println(((VoltageBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof CurrentBlock) {
                System.out.println(((CurrentBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof TemperatureBlock) {
                System.out.println(((TemperatureBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof AirspeedBlock) {
                System.out.println(((AirspeedBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof GPSLocationBlock) {
                System.out.println(((GPSLocationBlock)dataBlock).toString());
                GPSCollectorBlock.getInstance().updateLocation((GPSLocationBlock)dataBlock);
                if (!GPSCollectorBlock.getInstance().isUpdated()) continue;
                System.out.println(GPSCollectorBlock.getInstance().toString());
                continue;
            }
            if (dataBlock instanceof GPSStatusBlock) {
                System.out.println(((GPSStatusBlock)dataBlock).toString());
                GPSCollectorBlock.getInstance().updateStatus((GPSStatusBlock)dataBlock);
                if (!GPSCollectorBlock.getInstance().isUpdated()) continue;
                System.out.println(GPSCollectorBlock.getInstance().toString());
                continue;
            }
            if (dataBlock instanceof FlightPackBlock) {
                System.out.println(((FlightPackBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof EscBlock) {
                System.out.println(((EscBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof PowerBoxBlock) {
                System.out.println(((PowerBoxBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof JetCatBlock) {
                System.out.println(((JetCatBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof GForceBlock) {
                System.out.println(((GForceBlock)dataBlock).toString());
                continue;
            }
            if (dataBlock instanceof ServoDataBlock) {
                System.out.println(((ServoDataBlock)dataBlock).toString());
                continue;
            }
            System.out.println(dataBlock.toString());
        }
    }

    private static String duration(Duration flightDuration) {
        Period period = flightDuration.toPeriod();
        PeriodFormatter hms = new PeriodFormatterBuilder().appendHours().appendSeparator(":").printZeroAlways().appendMinutes().appendSeparator(":").appendSecondsWithMillis().toFormatter();
        return hms.print((ReadablePeriod)period);
    }
}

