/*
 * Decompiled with CFR 0.152.
 */
package gde.config;

import gde.messages.Messages;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class ExportService {
    final String name;
    final String manufacturer;
    final Set<DataFeed> dataFeeds;
    final String jar;

    public ExportService(String name, String manufacturer, Set<DataFeed> dataFeeds, String jarPath) {
        this.name = name;
        this.manufacturer = manufacturer;
        this.dataFeeds = dataFeeds;
        this.jar = jarPath;
    }

    public ExportService(String service, String jarPath) {
        String[] temp = service.split(":");
        if (temp.length != 3) {
            throw new IllegalArgumentException(String.format("wrong number of arguments in %s", service));
        }
        this.name = temp[0].trim();
        this.manufacturer = temp[1].trim();
        String[] inputTexts = temp[2].trim().split(";");
        this.dataFeeds = DataFeed.fromStringArray(inputTexts);
        this.jar = jarPath;
    }

    public String getName() {
        return this.name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getDataFeed() {
        return this.dataFeeds.stream().map(DataFeed::displayText).collect(Collectors.joining(";"));
    }

    public JarFile getJarFile() throws IOException {
        return new JarFile(this.jar);
    }

    public Path getJarPath() {
        return Paths.get(this.jar, new String[0]);
    }

    public String getDisplayText() {
        return String.join((CharSequence)":", this.name, this.manufacturer, this.getDataFeed());
    }

    public String toString() {
        String neutralSource = this.dataFeeds.stream().map(Enum::name).collect(Collectors.joining(";"));
        return String.join((CharSequence)":", this.name, this.manufacturer, neutralSource);
    }

    public static enum DataFeed {
        NO_DATA_SOURCE(" - "),
        SERIAL_IO("GDE_MSGT0955"),
        FILE("GDE_MSGT0956"),
        NATIVE_USB("GDE_MSGT0957"),
        NATIVE_TCP("GDE_MSGT0974");

        private String messageId;

        private DataFeed(String messageId) {
            this.messageId = messageId;
        }

        public String value() {
            return this.name();
        }

        public String displayText() {
            return this.messageId.length() > 3 ? Messages.getString(this.messageId) : this.messageId;
        }

        public static DataFeed fromValue(String v) {
            return DataFeed.valueOf(v);
        }

        public static LinkedHashSet<DataFeed> fromStringArray(String[] values) {
            LinkedHashSet<DataFeed> dataFeeds = new LinkedHashSet<DataFeed>();
            for (String value : values) {
                dataFeeds.add(DataFeed.valueOf(value));
            }
            return dataFeeds;
        }
    }
}

