/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.CMYKColor;
import com.itextpdf.text.pdf.ColorDetails;
import com.itextpdf.text.pdf.ExtendedColor;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.ICachedColorSpace;
import com.itextpdf.text.pdf.IPdfSpecialColorSpace;
import com.itextpdf.text.pdf.LabColor;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFunction;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfSpotColor;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.Arrays;
import java.util.Locale;

public class PdfDeviceNColor
implements ICachedColorSpace,
IPdfSpecialColorSpace {
    PdfSpotColor[] spotColors;
    ColorDetails[] colorantsDetails;

    public PdfDeviceNColor(PdfSpotColor[] spotColors) {
        this.spotColors = spotColors;
    }

    public int getNumberOfColorants() {
        return this.spotColors.length;
    }

    public PdfSpotColor[] getSpotColors() {
        return this.spotColors;
    }

    public ColorDetails[] getColorantDetails(PdfWriter writer) {
        if (this.colorantsDetails == null) {
            this.colorantsDetails = new ColorDetails[this.spotColors.length];
            int i2 = 0;
            for (PdfSpotColor spotColorant : this.spotColors) {
                this.colorantsDetails[i2] = writer.addSimple(spotColorant);
                ++i2;
            }
        }
        return this.colorantsDetails;
    }

    public PdfObject getPdfObject(PdfWriter writer) {
        int i2;
        PdfArray array = new PdfArray(PdfName.DEVICEN);
        PdfArray colorants = new PdfArray();
        float[] colorantsRanges = new float[this.spotColors.length * 2];
        PdfDictionary colorantsDict = new PdfDictionary();
        String psFunFooter = "";
        int numberOfColorants = this.spotColors.length;
        float[][] CMYK = new float[4][numberOfColorants];
        for (i2 = 0; i2 < numberOfColorants; ++i2) {
            PdfSpotColor spotColorant = this.spotColors[i2];
            colorantsRanges[2 * i2] = 0.0f;
            colorantsRanges[2 * i2 + 1] = 1.0f;
            colorants.add(spotColorant.getName());
            if (colorantsDict.get(spotColorant.getName()) != null) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("devicen.component.names.shall.be.different", new Object[0]));
            }
            if (this.colorantsDetails != null) {
                colorantsDict.put(spotColorant.getName(), this.colorantsDetails[i2].getIndirectReference());
            } else {
                colorantsDict.put(spotColorant.getName(), spotColorant.getPdfObject(writer));
            }
            BaseColor color = spotColorant.getAlternativeCS();
            if (color instanceof ExtendedColor) {
                int type2 = ((ExtendedColor)color).type;
                switch (type2) {
                    case 1: {
                        CMYK[0][i2] = 0.0f;
                        CMYK[1][i2] = 0.0f;
                        CMYK[2][i2] = 0.0f;
                        CMYK[3][i2] = 1.0f - ((GrayColor)color).getGray();
                        break;
                    }
                    case 2: {
                        CMYK[0][i2] = ((CMYKColor)color).getCyan();
                        CMYK[1][i2] = ((CMYKColor)color).getMagenta();
                        CMYK[2][i2] = ((CMYKColor)color).getYellow();
                        CMYK[3][i2] = ((CMYKColor)color).getBlack();
                        break;
                    }
                    case 7: {
                        CMYKColor cmyk = ((LabColor)color).toCmyk();
                        CMYK[0][i2] = cmyk.getCyan();
                        CMYK[1][i2] = cmyk.getMagenta();
                        CMYK[2][i2] = cmyk.getYellow();
                        CMYK[3][i2] = cmyk.getBlack();
                        break;
                    }
                    default: {
                        throw new RuntimeException(MessageLocalization.getComposedMessage("only.rgb.gray.and.cmyk.are.supported.as.alternative.color.spaces", new Object[0]));
                    }
                }
            } else {
                float r2 = color.getRed();
                float g2 = color.getGreen();
                float b2 = color.getBlue();
                float computedC = 0.0f;
                float computedM = 0.0f;
                float computedY = 0.0f;
                float computedK = 0.0f;
                if (r2 == 0.0f && g2 == 0.0f && b2 == 0.0f) {
                    computedK = 1.0f;
                } else {
                    computedC = 1.0f - r2 / 255.0f;
                    computedM = 1.0f - g2 / 255.0f;
                    computedY = 1.0f - b2 / 255.0f;
                    float minCMY = Math.min(computedC, Math.min(computedM, computedY));
                    computedC = (computedC - minCMY) / (1.0f - minCMY);
                    computedM = (computedM - minCMY) / (1.0f - minCMY);
                    computedY = (computedY - minCMY) / (1.0f - minCMY);
                    computedK = minCMY;
                }
                CMYK[0][i2] = computedC;
                CMYK[1][i2] = computedM;
                CMYK[2][i2] = computedY;
                CMYK[3][i2] = computedK;
            }
            psFunFooter = psFunFooter + "pop ";
        }
        array.add(colorants);
        String psFunHeader = String.format(Locale.US, "1.000000 %d 1 roll ", numberOfColorants + 1);
        array.add(PdfName.DEVICECMYK);
        psFunHeader = psFunHeader + psFunHeader + psFunHeader + psFunHeader;
        String psFun = "";
        for (i2 = numberOfColorants + 4; i2 > numberOfColorants; --i2) {
            psFun = psFun + String.format(Locale.US, "%d -1 roll ", i2);
            for (int j2 = numberOfColorants; j2 > 0; --j2) {
                psFun = psFun + String.format(Locale.US, "%d index %f mul 1.000000 cvr exch sub mul ", j2, Float.valueOf(CMYK[numberOfColorants + 4 - i2][numberOfColorants - j2]));
            }
            psFun = psFun + String.format(Locale.US, "1.000000 cvr exch sub %d 1 roll ", i2);
        }
        PdfFunction func = PdfFunction.type4(writer, colorantsRanges, new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f}, "{ " + psFunHeader + psFun + psFunFooter + "}");
        array.add(func.getReference());
        PdfDictionary attr = new PdfDictionary();
        attr.put(PdfName.SUBTYPE, PdfName.NCHANNEL);
        attr.put(PdfName.COLORANTS, colorantsDict);
        array.add(attr);
        return array;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof PdfDeviceNColor)) {
            return false;
        }
        PdfDeviceNColor that = (PdfDeviceNColor)o2;
        return Arrays.equals(this.spotColors, that.spotColors);
    }

    public int hashCode() {
        return Arrays.hashCode(this.spotColors);
    }
}

