/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.SplitCharacter;
import com.itextpdf.text.pdf.PdfChunk;

public class DefaultSplitCharacter
implements SplitCharacter {
    public static final SplitCharacter DEFAULT = new DefaultSplitCharacter();
    protected char[] characters;

    public DefaultSplitCharacter() {
    }

    public DefaultSplitCharacter(char character) {
        this(new char[]{character});
    }

    public DefaultSplitCharacter(char[] characters) {
        this.characters = characters;
    }

    public boolean isSplitCharacter(int start, int current, int end, char[] cc, PdfChunk[] ck) {
        char c2 = this.getCurrentCharacter(current, cc, ck);
        if (this.characters != null) {
            for (int i2 = 0; i2 < this.characters.length; ++i2) {
                if (c2 != this.characters[i2]) continue;
                return true;
            }
            return false;
        }
        if (c2 <= ' ' || c2 == '-' || c2 == '\u2010') {
            return true;
        }
        if (c2 < '\u2002') {
            return false;
        }
        return c2 >= '\u2002' && c2 <= '\u200b' || c2 >= '\u2e80' && c2 < '\ud7a0' || c2 >= '\uf900' && c2 < '\ufb00' || c2 >= '\ufe30' && c2 < '\ufe50' || c2 >= '\uff61' && c2 < '\uffa0';
    }

    protected char getCurrentCharacter(int current, char[] cc, PdfChunk[] ck) {
        if (ck == null) {
            return cc[current];
        }
        return (char)ck[Math.min(current, ck.length - 1)].getUnicodeEquivalent(cc[current]);
    }
}

