/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.GDE;
import gde.config.Settings;
import gde.io.ObjectDataReaderWriter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.Printer;

public class ObjectData {
    public static final String STRING_STYLED_TEXT_DEFAULT = Messages.getString("GDE_MSGT0433");
    String key;
    String type;
    String activationDate;
    String status;
    Image image;
    Properties properties;
    int imageWidth = 400;
    int imageHeight = 300;
    String styledText;
    StyleRange[] styleRanges;
    Font font;
    String fullQualifiedObjectFilePath;

    public ObjectData(String newKey, String newType, String newActivationDate, String newStatus, Image newImage, String newStyledText, StyleRange[] newStyleRanges, FontData fd) {
        this.key = newKey;
        this.type = newType;
        this.activationDate = newActivationDate;
        this.status = newStatus;
        this.image = newImage;
        this.styledText = newStyledText;
        this.styleRanges = (StyleRange[])newStyleRanges.clone();
        this.font = SWTResourceManager.getFont(fd.getName(), fd.getHeight(), fd.getStyle(), false, false);
    }

    public ObjectData(String objectFilePath) {
        this.fullQualifiedObjectFilePath = objectFilePath;
        this.key = objectFilePath.replace('\\', '/').substring(objectFilePath.lastIndexOf(47) + 1, objectFilePath.lastIndexOf(46));
        this.type = Messages.getString("GDE_MSGT0279");
        this.activationDate = Messages.getString("GDE_MSGT0279");
        this.status = Messages.getString("GDE_MSGT0279");
        this.image = null;
        this.styledText = STRING_STYLED_TEXT_DEFAULT;
        this.styleRanges = new StyleRange[]{new StyleRange(0, this.styledText.length(), null, null, 1)};
        this.font = GDE.IS_WINDOWS ? SWTResourceManager.getFont("Microsoft Sans Serif", 10, 0, false, false) : SWTResourceManager.getFont("Sans Serif", 10, 0, false, false);
    }

    public ObjectData(ObjectData objectData) {
        this.fullQualifiedObjectFilePath = Settings.getInstance().getDataFilePath() + objectData.key + GDE.FILE_SEPARATOR + objectData.key + ".zip";
        this.key = objectData.key;
        this.type = objectData.type;
        this.activationDate = objectData.activationDate;
        this.status = objectData.status;
        this.image = SWTResourceManager.getImage(objectData.image.getImageData(), this.key, this.imageWidth, this.imageHeight, false);
        this.styledText = objectData.styledText;
        Vector<StyleRange> tmpRanges = new Vector<StyleRange>();
        for (StyleRange range : objectData.styleRanges) {
            Color foreground = range.foreground != null ? SWTResourceManager.getColor(range.foreground.getRed(), range.foreground.getGreen(), range.foreground.getBlue()) : null;
            Color background = range.background != null ? SWTResourceManager.getColor(range.background.getRed(), range.background.getGreen(), range.background.getBlue()) : null;
            tmpRanges.add(new StyleRange(range.start, range.length, foreground, background, range.fontStyle));
        }
        this.styleRanges = tmpRanges.toArray(new StyleRange[0]);
    }

    public ObjectData(ObjectData objectData, String updateObjectKey) {
        this.fullQualifiedObjectFilePath = Settings.getInstance().getDataFilePath() + "/" + updateObjectKey + "/" + updateObjectKey + ".zip";
        this.key = objectData.key;
        this.type = objectData.type;
        this.activationDate = objectData.activationDate;
        this.status = objectData.status;
        this.image = objectData.image != null ? SWTResourceManager.getImage(objectData.image.getImageData(), this.key, this.imageWidth, this.imageHeight, false) : null;
        this.styledText = objectData.styledText;
        Vector<StyleRange> tmpRanges = new Vector<StyleRange>();
        for (StyleRange range : objectData.styleRanges) {
            Color foreground = range.foreground != null ? SWTResourceManager.getColor(range.foreground.getRed(), range.foreground.getGreen(), range.foreground.getBlue()) : null;
            Color background = range.background != null ? SWTResourceManager.getColor(range.background.getRed(), range.background.getGreen(), range.background.getBlue()) : null;
            tmpRanges.add(new StyleRange(range.start, range.length, foreground, background, range.fontStyle));
        }
        this.styleRanges = tmpRanges.toArray(new StyleRange[0]);
        this.key = updateObjectKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(String newActivationDate) {
        this.activationDate = newActivationDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String newStatus) {
        this.status = newStatus;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image newImage) {
        this.image = newImage;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getStyledText() {
        return this.styledText;
    }

    public void setStyledText(String newStyledText) {
        this.styledText = newStyledText;
    }

    public StyleRange[] getStyleRanges() {
        return this.styleRanges;
    }

    public void setStyleRanges(StyleRange[] newStyleRanges) {
        this.styleRanges = newStyleRanges;
    }

    public synchronized void save() {
        ObjectDataReaderWriter objWriter = new ObjectDataReaderWriter(this);
        objWriter.write();
    }

    public synchronized void load() {
        ObjectDataReaderWriter objReader = new ObjectDataReaderWriter(this);
        objReader.read();
    }

    public void print() {
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.header = "\t" + this.fullQualifiedObjectFilePath + "\t";
        options.footer = "\t<page>\tDataExplorer";
        options.printLineBackground = true;
        options.printTextBackground = true;
        options.printTextFontStyle = true;
        options.printTextForeground = true;
        options.lineLabels = new String[]{this.key, this.type, this.activationDate, this.status};
        StyledText tmpStyledText = new StyledText(DataExplorer.getInstance().getParent(), 0);
        tmpStyledText.setFont(this.font);
        tmpStyledText.setText(this.styledText);
        tmpStyledText.setStyleRanges(this.styleRanges);
        tmpStyledText.print(new Printer()).run();
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int newWidth) {
        this.imageWidth = newWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int newHeight) {
        this.imageHeight = newHeight;
    }

    public FontData getFontData() {
        return this.font != null ? this.font.getFontData()[0] : SWTResourceManager.getFont("Sans Serif", 10, 0, false, false).getFontData()[0];
    }

    public void setFont(Font newFont) {
        this.font = newFont;
    }

    public String getFullQualifiedObjectFilePath() {
        return this.fullQualifiedObjectFilePath;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties newProperties) {
        this.properties = (Properties)newProperties.clone();
    }
}

