/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.config.Settings;
import gde.device.TrailTypes;
import gde.histo.recordings.TrailDataTags;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordFormatter;
import gde.histo.recordings.TrailRecordSet;
import gde.messages.Messages;
import gde.utils.LocalizedDateTime;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class HistoTableMapper {
    public static String[] getTableHeaderRow(TrailRecordSet trailRecordSet) {
        int dataSize = trailRecordSet.getTimeStepSize();
        String[] dataTableRow = new String[dataSize];
        if (Settings.getInstance().isXAxisReversed()) {
            for (int i = 0; i < dataSize; ++i) {
                dataTableRow[i] = LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmmss, trailRecordSet.getTime_ms(i));
            }
        } else {
            int i = 0;
            int j = dataSize - 1;
            while (i < dataSize) {
                dataTableRow[i] = LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmmss, trailRecordSet.getTime_ms(j));
                ++i;
                --j;
            }
        }
        return dataTableRow;
    }

    public static String[] getTableRow(TrailRecord trailRecord) {
        int dataSize = trailRecord.getParent().getTimeStepSize();
        String[] dataTableRow = new String[dataSize + 2];
        Function<Integer, String> valueFunction = HistoTableMapper.valueCreator(trailRecord);
        if (Settings.getInstance().isXAxisReversed()) {
            for (int i = 0; i < dataSize; ++i) {
                dataTableRow[i + 2] = valueFunction.apply(i);
            }
        } else {
            int i = 0;
            int j = dataSize - 1;
            while (i < dataSize) {
                dataTableRow[i + 2] = valueFunction.apply(j);
                ++i;
                --j;
            }
        }
        dataTableRow[0] = trailRecord.getTableRowHeader().intern();
        dataTableRow[1] = trailRecord.getTrailSelector().getTrailText().intern();
        return dataTableRow;
    }

    private static Function<Integer, String> valueCreator(TrailRecord trailRecord) {
        return !trailRecord.getTrailSelector().isTrailSuite() ? index -> {
            String cellValue = "";
            if (trailRecord.elementAt((int)index) != null) {
                TrailRecordFormatter formatter = new TrailRecordFormatter(trailRecord);
                cellValue = formatter.getTableValue((int)index);
            }
            return cellValue;
        } : index -> {
            String cellValue = "";
            int trailOrdinal = trailRecord.getTrailSelector().getTrailOrdinal();
            TrailTypes trailType = TrailTypes.fromOrdinal(trailOrdinal);
            if (trailRecord.getSuiteRecords().getSuiteValue(trailRecord.getTrailSelector().getSuiteMasterIndex(), (int)index) != null) {
                TrailRecordFormatter formatter = new TrailRecordFormatter(trailRecord);
                cellValue = formatter.getTableSuiteValue((int)index, trailType);
            }
            return cellValue;
        };
    }

    public static String[] getTableTagRow(TrailRecordSet trailRecordSet, DisplayTag displayTag) {
        return displayTag.getTableTagRow(trailRecordSet);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DisplayTag {
        FILE_NAME{

            @Override
            String[] getTableTagRow(TrailRecordSet trailRecordSet) {
                BiFunction<TrailDataTags, Integer, String> scoreFunction = (t, i) -> Paths.get((String)((List)t.get((Object)TrailDataTags.DataTag.FILE_PATH)).get((int)i), new String[0]).getFileName().toString();
                String[] dataTableRow = DisplayTag.getTagRowWithValues(trailRecordSet, scoreFunction);
                dataTableRow[1] = Messages.getString("GDE_MSGT0838");
                return dataTableRow;
            }
        }
        ,
        DIRECTORY_NAME{

            @Override
            String[] getTableTagRow(TrailRecordSet trailRecordSet) {
                BiFunction<TrailDataTags, Integer, String> scoreFunction = (t, i) -> {
                    Path fullPath = Paths.get((String)((List)t.get((Object)t.getSourcePathTag((int)i))).get((int)i), new String[0]);
                    return fullPath.getParent().getFileName().toString();
                };
                String[] dataTableRow = DisplayTag.getTagRowWithValues(trailRecordSet, scoreFunction);
                dataTableRow[1] = Messages.getString("GDE_MSGT0839");
                return dataTableRow;
            }
        }
        ,
        BASE_PATH{

            @Override
            String[] getTableTagRow(TrailRecordSet trailRecordSet) {
                BiFunction<TrailDataTags, Integer, String> scoreFunction = (t, i) -> {
                    Path fullPath = Paths.get((String)((List)t.get((Object)t.getSourcePathTag((int)i))).get((int)i), new String[0]);
                    if (fullPath.getNameCount() > 4) {
                        return fullPath.subpath(fullPath.getNameCount() - 5, fullPath.getNameCount() - 2).toString();
                    }
                    if (fullPath.getNameCount() > 2) {
                        return fullPath.getParent().getParent().toString();
                    }
                    return "";
                };
                String[] dataTableRow = DisplayTag.getTagRowWithValues(trailRecordSet, scoreFunction);
                dataTableRow[1] = Messages.getString("GDE_MSGT0840");
                return dataTableRow;
            }
        }
        ,
        CHANNEL_NUMBER{

            @Override
            String[] getTableTagRow(TrailRecordSet trailRecordSet) {
                BiFunction<TrailDataTags, Integer, String> scoreFunction = (t, i) -> (String)((List)t.get((Object)TrailDataTags.DataTag.CHANNEL_NUMBER)).get((int)i);
                String[] dataTableRow = DisplayTag.getTagRowWithValues(trailRecordSet, scoreFunction);
                dataTableRow[1] = Messages.getString("GDE_MSGT0841");
                return dataTableRow;
            }
        }
        ,
        RECTIFIED_OBJECTKEY{

            @Override
            String[] getTableTagRow(TrailRecordSet trailRecordSet) {
                BiFunction<TrailDataTags, Integer, String> scoreFunction = (t, i) -> (String)((List)t.get((Object)TrailDataTags.DataTag.RECTIFIED_OBJECTKEY)).get((int)i);
                String[] dataTableRow = DisplayTag.getTagRowWithValues(trailRecordSet, scoreFunction);
                dataTableRow[1] = Messages.getString("GDE_MSGT0842");
                return dataTableRow;
            }
        }
        ,
        RECORDSET_BASE_NAME{

            @Override
            String[] getTableTagRow(TrailRecordSet trailRecordSet) {
                BiFunction<TrailDataTags, Integer, String> scoreFunction = (t, i) -> (String)((List)t.get((Object)TrailDataTags.DataTag.RECORDSET_BASE_NAME)).get((int)i);
                String[] dataTableRow = DisplayTag.getTagRowWithValues(trailRecordSet, scoreFunction);
                dataTableRow[1] = Messages.getString("GDE_MSGT0844");
                return dataTableRow;
            }
        }
        ,
        GPS_LOCATION{

            @Override
            String[] getTableTagRow(TrailRecordSet trailRecordSet) {
                BiFunction<TrailDataTags, Integer, String> scoreFunction = (t, i) -> (String)((List)t.get((Object)TrailDataTags.DataTag.GPS_LOCATION)).get((int)i);
                String[] dataTableRow = DisplayTag.getTagRowWithValues(trailRecordSet, scoreFunction);
                dataTableRow[1] = Messages.getString("GDE_MSGT0845");
                return dataTableRow;
            }
        };

        public static final DisplayTag[] VALUES;

        static DisplayTag fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        abstract String[] getTableTagRow(TrailRecordSet var1);

        private static String[] getTagRowWithValues(TrailRecordSet trailRecordSet, BiFunction<TrailDataTags, Integer, String> scoreFunction) {
            int dataSize = trailRecordSet.getTimeStepSize();
            String[] dataTableRow = new String[dataSize + 2];
            if (Settings.getInstance().isXAxisReversed()) {
                for (int i = 0; i < dataSize; ++i) {
                    dataTableRow[i + 2] = scoreFunction.apply(trailRecordSet.getDataTags(), i);
                }
            } else {
                int i = 0;
                int j = dataSize - 1;
                while (i < dataSize) {
                    dataTableRow[i + 2] = scoreFunction.apply(trailRecordSet.getDataTags(), j);
                    ++i;
                    --j;
                }
            }
            return dataTableRow;
        }

        static {
            VALUES = DisplayTag.values();
        }
    }
}

