/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import java.util.Arrays;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.general.AbstractLeastSquaresOptimizer;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LevenbergMarquardtOptimizer
extends AbstractLeastSquaresOptimizer {
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;
    private double[] weightedResidual;
    private double[][] weightedJacobian;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(ConvergenceChecker<PointVectorValuePair> checker) {
        this(100.0, checker, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double initialStepBoundFactor, ConvergenceChecker<PointVectorValuePair> checker, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, double threshold) {
        super(checker);
        this.initialStepBoundFactor = initialStepBoundFactor;
        this.costRelativeTolerance = costRelativeTolerance;
        this.parRelativeTolerance = parRelativeTolerance;
        this.orthoTolerance = orthoTolerance;
        this.qrRankingThreshold = threshold;
    }

    public LevenbergMarquardtOptimizer(double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance) {
        this(100.0, costRelativeTolerance, parRelativeTolerance, orthoTolerance, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double initialStepBoundFactor, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, double threshold) {
        super(null);
        this.initialStepBoundFactor = initialStepBoundFactor;
        this.costRelativeTolerance = costRelativeTolerance;
        this.parRelativeTolerance = parRelativeTolerance;
        this.orthoTolerance = orthoTolerance;
        this.qrRankingThreshold = threshold;
    }

    @Override
    protected PointVectorValuePair doOptimize() {
        int nR = this.getTarget().length;
        double[] currentPoint = this.getStartPoint();
        int nC = currentPoint.length;
        this.solvedCols = FastMath.min(nR, nC);
        this.diagR = new double[nC];
        this.jacNorm = new double[nC];
        this.beta = new double[nC];
        this.permutation = new int[nC];
        this.lmDir = new double[nC];
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[nC];
        double[] oldX = new double[nC];
        double[] oldRes = new double[nR];
        double[] oldObj = new double[nR];
        double[] qtf = new double[nR];
        double[] work1 = new double[nC];
        double[] work2 = new double[nC];
        double[] work3 = new double[nC];
        RealMatrix weightMatrixSqrt = this.getWeightSquareRoot();
        double[] currentObjective = this.computeObjectiveValue(currentPoint);
        double[] currentResiduals = this.computeResiduals(currentObjective);
        PointVectorValuePair current = new PointVectorValuePair(currentPoint, currentObjective);
        double currentCost = this.computeCost(currentResiduals);
        this.lmPar = 0.0;
        boolean firstIteration = true;
        int iter = 0;
        ConvergenceChecker<PointVectorValuePair> checker = this.getConvergenceChecker();
        block0: while (true) {
            int j2;
            int k2;
            ++iter;
            PointVectorValuePair previous = current;
            this.qrDecomposition(this.computeWeightedJacobian(currentPoint));
            this.weightedResidual = weightMatrixSqrt.operate(currentResiduals);
            for (int i2 = 0; i2 < nR; ++i2) {
                qtf[i2] = this.weightedResidual[i2];
            }
            this.qTy(qtf);
            for (k2 = 0; k2 < this.solvedCols; ++k2) {
                int pk = this.permutation[k2];
                this.weightedJacobian[k2][pk] = this.diagR[pk];
            }
            if (firstIteration) {
                xNorm = 0.0;
                for (k2 = 0; k2 < nC; ++k2) {
                    double dk = this.jacNorm[k2];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * currentPoint[k2];
                    xNorm += xk * xk;
                    diag[k2] = dk;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (currentCost != 0.0) {
                for (j2 = 0; j2 < this.solvedCols; ++j2) {
                    int pj = this.permutation[j2];
                    double s2 = this.jacNorm[pj];
                    if (s2 == 0.0) continue;
                    double sum = 0.0;
                    for (int i3 = 0; i3 <= j2; ++i3) {
                        sum += this.weightedJacobian[i3][pj] * qtf[i3];
                    }
                    maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s2 * currentCost));
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                this.setCost(currentCost);
                this.point = current.getPoint();
                return current;
            }
            for (j2 = 0; j2 < nC; ++j2) {
                diag[j2] = FastMath.max(diag[j2], this.jacNorm[j2]);
            }
            double ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) continue block0;
                for (int j3 = 0; j3 < this.solvedCols; ++j3) {
                    int pj = this.permutation[j3];
                    oldX[pj] = currentPoint[pj];
                }
                double previousCost = currentCost;
                double[] tmpVec = this.weightedResidual;
                this.weightedResidual = oldRes;
                oldRes = tmpVec;
                tmpVec = currentObjective;
                currentObjective = oldObj;
                oldObj = tmpVec;
                this.determineLMParameter(qtf, delta, diag, work1, work2, work3);
                double lmNorm = 0.0;
                for (int j4 = 0; j4 < this.solvedCols; ++j4) {
                    int pj = this.permutation[j4];
                    this.lmDir[pj] = -this.lmDir[pj];
                    currentPoint[pj] = oldX[pj] + this.lmDir[pj];
                    double s3 = diag[pj] * this.lmDir[pj];
                    lmNorm += s3 * s3;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                currentObjective = this.computeObjectiveValue(currentPoint);
                currentResiduals = this.computeResiduals(currentObjective);
                current = new PointVectorValuePair(currentPoint, currentObjective);
                currentCost = this.computeCost(currentResiduals);
                double actRed = -1.0;
                if (0.1 * currentCost < previousCost) {
                    double r2 = currentCost / previousCost;
                    actRed = 1.0 - r2 * r2;
                }
                for (int j5 = 0; j5 < this.solvedCols; ++j5) {
                    int pj = this.permutation[j5];
                    double dirJ = this.lmDir[pj];
                    work1[j5] = 0.0;
                    for (int i4 = 0; i4 <= j5; ++i4) {
                        int n2 = i4;
                        work1[n2] = work1[n2] + this.weightedJacobian[i4][pj] * dirJ;
                    }
                }
                double coeff1 = 0.0;
                for (int j6 = 0; j6 < this.solvedCols; ++j6) {
                    coeff1 += work1[j6] * work1[j6];
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = this.lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d2 = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d3 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * currentCost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    this.lmPar /= tmp;
                } else if (this.lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    this.lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    for (int k3 = 0; k3 < nC; ++k3) {
                        double xK = diag[k3] * currentPoint[k3];
                        xNorm += xK * xK;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                    if (checker != null && checker.converged(iter, previous, current)) {
                        this.setCost(currentCost);
                        this.point = current.getPoint();
                        return current;
                    }
                } else {
                    currentCost = previousCost;
                    for (int j7 = 0; j7 < this.solvedCols; ++j7) {
                        int pj = this.permutation[j7];
                        currentPoint[pj] = oldX[pj];
                    }
                    tmpVec = this.weightedResidual;
                    this.weightedResidual = oldRes;
                    oldRes = tmpVec;
                    tmpVec = currentObjective;
                    currentObjective = oldObj;
                    oldObj = tmpVec;
                    current = new PointVectorValuePair(currentPoint, currentObjective);
                }
                if (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm) {
                    this.setCost(currentCost);
                    this.point = current.getPoint();
                    return current;
                }
                if (FastMath.abs(actRed) <= 2.2204E-16 && preRed <= 2.2204E-16 && ratio <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(delta <= 2.2204E-16 * xNorm)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(maxCosine <= 2.2204E-16));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private void determineLMParameter(double[] qy, double delta, double[] diag, double[] work1, double[] work2, double[] work3) {
        double sum;
        int pj;
        int j2;
        int j3;
        int nC = this.weightedJacobian[0].length;
        for (j3 = 0; j3 < this.rank; ++j3) {
            this.lmDir[this.permutation[j3]] = qy[j3];
        }
        for (j3 = this.rank; j3 < nC; ++j3) {
            this.lmDir[this.permutation[j3]] = 0.0;
        }
        for (int k2 = this.rank - 1; k2 >= 0; --k2) {
            int pk = this.permutation[k2];
            double ypk = this.lmDir[pk] / this.diagR[pk];
            for (int i2 = 0; i2 < k2; ++i2) {
                int n2 = this.permutation[i2];
                this.lmDir[n2] = this.lmDir[n2] - ypk * this.weightedJacobian[i2][pk];
            }
            this.lmDir[pk] = ypk;
        }
        double dxNorm = 0.0;
        for (int j4 = 0; j4 < this.solvedCols; ++j4) {
            double s2;
            int pj2 = this.permutation[j4];
            work1[pj2] = s2 = diag[pj2] * this.lmDir[pj2];
            dxNorm += s2 * s2;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            this.lmPar = 0.0;
            return;
        }
        double parl = 0.0;
        if (this.rank == this.solvedCols) {
            for (j2 = 0; j2 < this.solvedCols; ++j2) {
                int n3 = pj = this.permutation[j2];
                work1[n3] = work1[n3] * (diag[pj] / dxNorm);
            }
            double sum2 = 0.0;
            for (j2 = 0; j2 < this.solvedCols; ++j2) {
                double s3;
                pj = this.permutation[j2];
                sum = 0.0;
                for (int i3 = 0; i3 < j2; ++i3) {
                    sum += this.weightedJacobian[i3][pj] * work1[this.permutation[i3]];
                }
                work1[pj] = s3 = (work1[pj] - sum) / this.diagR[pj];
                sum2 += s3 * s3;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            pj = this.permutation[j2];
            sum = 0.0;
            for (int i4 = 0; i4 <= j2; ++i4) {
                sum += this.weightedJacobian[i4][pj] * qy[i4];
            }
            sum2 += (sum /= diag[pj]) * sum;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = 2.2251E-308 / FastMath.min(delta, 0.1);
        }
        this.lmPar = FastMath.min(paru, FastMath.max(this.lmPar, parl));
        if (this.lmPar == 0.0) {
            this.lmPar = gNorm / dxNorm;
        }
        for (int countdown = 10; countdown >= 0; --countdown) {
            int pj3;
            int j5;
            int pj4;
            int j6;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(2.2251E-308, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(this.lmPar);
            for (j6 = 0; j6 < this.solvedCols; ++j6) {
                pj4 = this.permutation[j6];
                work1[pj4] = sPar * diag[pj4];
            }
            this.determineLMDirection(qy, work1, work2, work3);
            dxNorm = 0.0;
            for (j6 = 0; j6 < this.solvedCols; ++j6) {
                double s4;
                pj4 = this.permutation[j6];
                work3[pj4] = s4 = diag[pj4] * this.lmDir[pj4];
                dxNorm += s4 * s4;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return;
            }
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                pj3 = this.permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
            }
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                int n4 = pj3 = this.permutation[j5];
                work1[n4] = work1[n4] / work2[j5];
                double tmp = work1[pj3];
                for (int i5 = j5 + 1; i5 < this.solvedCols; ++i5) {
                    int n5 = this.permutation[i5];
                    work1[n5] = work1[n5] - this.weightedJacobian[i5][pj3] * tmp;
                }
            }
            sum2 = 0.0;
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                double s5 = work1[this.permutation[j5]];
                sum2 += s5 * s5;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, this.lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, this.lmPar);
            }
            this.lmPar = FastMath.max(parl, this.lmPar + correction);
        }
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, double[] work) {
        int j2;
        int pj;
        int j3;
        for (j3 = 0; j3 < this.solvedCols; ++j3) {
            pj = this.permutation[j3];
            for (int i2 = j3 + 1; i2 < this.solvedCols; ++i2) {
                this.weightedJacobian[i2][pj] = this.weightedJacobian[j3][this.permutation[i2]];
            }
            this.lmDir[j3] = this.diagR[pj];
            work[j3] = qy[j3];
        }
        for (j3 = 0; j3 < this.solvedCols; ++j3) {
            pj = this.permutation[j3];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j3 + 1, lmDiag.length, 0.0);
            }
            lmDiag[j3] = dpj;
            double qtbpj = 0.0;
            for (int k2 = j3; k2 < this.solvedCols; ++k2) {
                double cos;
                double sin;
                int pk = this.permutation[k2];
                if (lmDiag[k2] == 0.0) continue;
                double rkk = this.weightedJacobian[k2][pk];
                if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k2])) {
                    double cotan = rkk / lmDiag[k2];
                    sin = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                    cos = sin * cotan;
                } else {
                    double tan = lmDiag[k2] / rkk;
                    cos = 1.0 / FastMath.sqrt(1.0 + tan * tan);
                    sin = cos * tan;
                }
                this.weightedJacobian[k2][pk] = cos * rkk + sin * lmDiag[k2];
                double temp = cos * work[k2] + sin * qtbpj;
                qtbpj = -sin * work[k2] + cos * qtbpj;
                work[k2] = temp;
                for (int i3 = k2 + 1; i3 < this.solvedCols; ++i3) {
                    double rik = this.weightedJacobian[i3][pk];
                    double temp2 = cos * rik + sin * lmDiag[i3];
                    lmDiag[i3] = -sin * rik + cos * lmDiag[i3];
                    this.weightedJacobian[i3][pk] = temp2;
                }
            }
            lmDiag[j3] = this.weightedJacobian[j3][this.permutation[j3]];
            this.weightedJacobian[j3][this.permutation[j3]] = this.lmDir[j3];
        }
        int nSing = this.solvedCols;
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            if (lmDiag[j2] == 0.0 && nSing == this.solvedCols) {
                nSing = j2;
            }
            if (nSing >= this.solvedCols) continue;
            work[j2] = 0.0;
        }
        if (nSing > 0) {
            for (j2 = nSing - 1; j2 >= 0; --j2) {
                int pj2 = this.permutation[j2];
                double sum = 0.0;
                for (int i4 = j2 + 1; i4 < nSing; ++i4) {
                    sum += this.weightedJacobian[i4][pj2] * work[i4];
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
            }
        }
        for (j2 = 0; j2 < this.lmDir.length; ++j2) {
            this.lmDir[this.permutation[j2]] = work[j2];
        }
    }

    private void qrDecomposition(RealMatrix jacobian) throws ConvergenceException {
        int k2;
        this.weightedJacobian = jacobian.scalarMultiply(-1.0).getData();
        int nR = this.weightedJacobian.length;
        int nC = this.weightedJacobian[0].length;
        for (k2 = 0; k2 < nC; ++k2) {
            this.permutation[k2] = k2;
            double norm2 = 0.0;
            for (int i2 = 0; i2 < nR; ++i2) {
                double akk = this.weightedJacobian[i2][k2];
                norm2 += akk * akk;
            }
            this.jacNorm[k2] = FastMath.sqrt(norm2);
        }
        for (k2 = 0; k2 < nC; ++k2) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            for (int i3 = k2; i3 < nC; ++i3) {
                double norm2 = 0.0;
                for (int j2 = k2; j2 < nR; ++j2) {
                    double aki = this.weightedJacobian[j2][this.permutation[i3]];
                    norm2 += aki * aki;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, nR, nC);
                }
                if (!(norm2 > ak2)) continue;
                nextColumn = i3;
                ak2 = norm2;
            }
            if (ak2 <= this.qrRankingThreshold) {
                this.rank = k2;
                return;
            }
            int pk = this.permutation[nextColumn];
            this.permutation[nextColumn] = this.permutation[k2];
            this.permutation[k2] = pk;
            double akk = this.weightedJacobian[k2][pk];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            this.beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            this.diagR[pk] = alpha;
            double[] dArray = this.weightedJacobian[k2];
            int n2 = pk;
            dArray[n2] = dArray[n2] - alpha;
            for (int dk = nC - 1 - k2; dk > 0; --dk) {
                int j3;
                double gamma = 0.0;
                for (j3 = k2; j3 < nR; ++j3) {
                    gamma += this.weightedJacobian[j3][pk] * this.weightedJacobian[j3][this.permutation[k2 + dk]];
                }
                gamma *= betak;
                for (j3 = k2; j3 < nR; ++j3) {
                    double[] dArray2 = this.weightedJacobian[j3];
                    int n3 = this.permutation[k2 + dk];
                    dArray2[n3] = dArray2[n3] - gamma * this.weightedJacobian[j3][pk];
                }
            }
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] y2) {
        int nR = this.weightedJacobian.length;
        int nC = this.weightedJacobian[0].length;
        for (int k2 = 0; k2 < nC; ++k2) {
            int i2;
            int pk = this.permutation[k2];
            double gamma = 0.0;
            for (i2 = k2; i2 < nR; ++i2) {
                gamma += this.weightedJacobian[i2][pk] * y2[i2];
            }
            gamma *= this.beta[pk];
            for (i2 = k2; i2 < nR; ++i2) {
                int n2 = i2;
                y2[n2] = y2[n2] - gamma * this.weightedJacobian[i2][pk];
            }
        }
    }
}

