/*
 * Decompiled with CFR 0.152.
 */
package gde.device.weatronic;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.device.ChannelPropertyTypes;
import gde.device.DataTypes;
import gde.device.DeviceDialog;
import gde.device.weatronic.WeatronicAdapter;
import gde.device.weatronic.WeatronicAdapterDialogTabItem;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class WeatronicAdapterDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(WeatronicAdapterDialog.class.getName());
    CTabFolder tabFolder;
    CTabItem serialComTabItem;
    Composite configMainComosite;
    Button saveButton;
    Button closeButton;
    Button helpButton;
    Button inputFileButton;
    Button enableChannelRecords;
    Button enableStatusFilter;
    Button enableUtcTimeFilter;
    final WeatronicAdapter device;
    final Settings settings;
    boolean isVisibilityChanged = false;

    public WeatronicAdapterDialog(Shell parent, WeatronicAdapter useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.setSize(620, 582);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                WeatronicAdapterDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        if (WeatronicAdapterDialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{WeatronicAdapterDialog.this.device.getPropertiesFileName()});
                            if (WeatronicAdapterDialog.this.application.openYesNoMessageDialog(WeatronicAdapterDialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                WeatronicAdapterDialog.this.device.storeDeviceProperties();
                                WeatronicAdapterDialog.this.setClosePossible(true);
                            }
                        }
                        WeatronicAdapterDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        WeatronicAdapterDialog.this.application.openHelpDialog("WeatronicAdapter", "HelpInfo.html");
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                for (int i = 0; i < this.device.getChannelCount(); ++i) {
                    new WeatronicAdapterDialogTabItem(this.tabFolder, this, i + 1, this.device);
                }
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -100);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + String.valueOf(evt));
                        int channelNumber = WeatronicAdapterDialog.this.tabFolder.getSelectionIndex() + 1;
                        if (channelNumber > 0 && channelNumber <= WeatronicAdapterDialog.this.device.getChannelCount()) {
                            String configKey = channelNumber + " : " + ((CTabItem)evt.item).getText();
                            Channels.getInstance().switchChannel(configKey);
                        }
                    }
                });
                this.enableChannelRecords = new Button((Composite)this.dialogShell, 32);
                FormData enableFilterLData = new FormData();
                enableFilterLData.height = GDE.IS_MAC ? 22 : 20;
                enableFilterLData.left = new FormAttachment(0, 1000, 10);
                enableFilterLData.width = 150;
                enableFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -48 : -50);
                this.enableChannelRecords.setLayoutData((Object)enableFilterLData);
                this.enableChannelRecords.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.enableChannelRecords.setText(Messages.getString((String)"GDE_MSGT3724"));
                this.enableChannelRecords.setToolTipText(Messages.getString((String)"GDE_MSGT3725"));
                this.enableChannelRecords.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "enableChannelRecords.widgetSelected, event=" + String.valueOf(evt));
                        WeatronicAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL, DataTypes.BOOLEAN, "" + WeatronicAdapterDialog.this.enableChannelRecords.getSelection());
                        WeatronicAdapter.setChannelFilter(WeatronicAdapterDialog.this.enableChannelRecords.getSelection());
                        WeatronicAdapterDialog.this.enableSaveButton(true);
                    }
                });
                this.enableStatusFilter = new Button((Composite)this.dialogShell, 32);
                enableFilterLData = new FormData();
                enableFilterLData.height = GDE.IS_MAC ? 22 : 20;
                enableFilterLData.left = new FormAttachment(0, 1000, 250);
                enableFilterLData.width = 120;
                enableFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -48 : -50);
                this.enableStatusFilter.setLayoutData((Object)enableFilterLData);
                this.enableStatusFilter.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.enableStatusFilter.setText(Messages.getString((String)"GDE_MSGT3717"));
                this.enableStatusFilter.setToolTipText(Messages.getString((String)"GDE_MSGT3718"));
                this.enableStatusFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "enableFilter.widgetSelected, event=" + String.valueOf(evt));
                        WeatronicAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.ENABLE_FILTER, DataTypes.BOOLEAN, "" + WeatronicAdapterDialog.this.enableStatusFilter.getSelection());
                        WeatronicAdapter.setStatusFilter(WeatronicAdapterDialog.this.enableStatusFilter.getSelection());
                        WeatronicAdapterDialog.this.enableSaveButton(true);
                    }
                });
                this.enableUtcTimeFilter = new Button((Composite)this.dialogShell, 32);
                FormData enableTextModusFilterLData = new FormData();
                enableTextModusFilterLData.height = GDE.IS_MAC ? 22 : 20;
                enableTextModusFilterLData.left = new FormAttachment(0, 1000, 480);
                enableTextModusFilterLData.width = 100;
                enableTextModusFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -48 : -50);
                this.enableUtcTimeFilter.setLayoutData((Object)enableTextModusFilterLData);
                this.enableUtcTimeFilter.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.enableUtcTimeFilter.setText(Messages.getString((String)"GDE_MSGT3715"));
                this.enableUtcTimeFilter.setToolTipText(Messages.getString((String)"GDE_MSGT3716"));
                this.enableUtcTimeFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "enableTextModusFilter.widgetSelected, event=" + String.valueOf(evt));
                        WeatronicAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.TEXT_MODE, DataTypes.BOOLEAN, "" + WeatronicAdapterDialog.this.enableUtcTimeFilter.getSelection());
                        WeatronicAdapter.setUtcFilter(WeatronicAdapterDialog.this.enableUtcTimeFilter.getSelection());
                        WeatronicAdapterDialog.this.enableSaveButton(true);
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 10);
                inputFileButtonLData.width = 160;
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT3702"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT3701"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + String.valueOf(evt));
                        if (WeatronicAdapterDialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{WeatronicAdapterDialog.this.device.getPropertiesFileName()});
                            if (WeatronicAdapterDialog.this.application.openYesNoMessageDialog(WeatronicAdapterDialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                WeatronicAdapterDialog.this.device.storeDeviceProperties();
                            }
                        }
                        WeatronicAdapterDialog.this.device.open_closeCommPort();
                    }
                });
                this.saveButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 105;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 190);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveButton.setLayoutData((Object)saveButtonLData);
                this.saveButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveButton.setText(Messages.getString((String)"GDE_MSGT0486"));
                this.saveButton.setEnabled(false);
                this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + String.valueOf(evt));
                        WeatronicAdapterDialog.this.device.storeDeviceProperties();
                        WeatronicAdapterDialog.this.saveButton.setEnabled(false);
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = 105;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.right = new FormAttachment(1000, 1000, -190);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                        WeatronicAdapterDialog.this.application.openHelpDialog("WeatronicAdapter", "HelpInfo.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 160;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                        WeatronicAdapterDialog.this.dialogShell.dispose();
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - this.dialogShell.getSize().x / 2, 0));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            this.enableChannelRecords.setSelection(Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue() != null ? this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue() : "true"));
            this.enableStatusFilter.setSelection(Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue() != null ? this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue() : "true"));
            this.enableUtcTimeFilter.setSelection(Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue() != null ? this.device.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue() : "true"));
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void enableSaveButton(boolean enable) {
        this.saveButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    public void selectTab(final int index) {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            this.dialogShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WeatronicAdapterDialog.this.tabFolder.setSelection(index - 1);
                }
            });
        }
    }
}

