/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.settlements;

import gde.Analyzer;
import gde.config.Settings;
import gde.device.CalculusTypes;
import gde.device.ChannelPropertyType;
import gde.device.ChannelPropertyTypes;
import gde.device.ChannelType;
import gde.device.DeltaBasisTypes;
import gde.device.IDevice;
import gde.device.LevelingTypes;
import gde.device.TransitionCalculusType;
import gde.histo.settlements.RecordGroup;
import gde.histo.settlements.SettlementRecord;
import gde.histo.transitions.Transition;
import gde.histo.utils.SingleResponseRegression;
import gde.histo.utils.UniversalQuantile;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

public final class CalculusEvaluator {
    private static final String $CLASS_NAME = CalculusEvaluator.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final SettlementRecord histoSettlement;
    private final Analyzer analyzer;
    private final TransitionCalculusType calculus;
    private final ChannelType logChannel;
    private final RecordGroup recordGroup;

    public CalculusEvaluator(SettlementRecord newHistoSettlement, Analyzer analyzer) {
        this.histoSettlement = newHistoSettlement;
        this.analyzer = analyzer;
        this.calculus = newHistoSettlement.getSettlement().getEvaluation().getTransitionCalculus();
        this.logChannel = analyzer.getActiveDevice().getDeviceConfiguration().getChannel(newHistoSettlement.getLogChannelNumber());
        this.recordGroup = new RecordGroup(newHistoSettlement, this.logChannel.getReferenceGroupById(this.calculus.getReferenceGroupId()), analyzer);
        log.log(Level.FINEST, ">", this.calculus);
    }

    public void addFromTransition(Transition transition) {
        if (this.recordGroup.hasReasonableData()) {
            int reverseTranslatedResult;
            CalculusTypes calculusType = this.calculus.getCalculusType();
            if (calculusType == CalculusTypes.DELTA) {
                double deltaValue = this.calculateLevelDelta(this.recordGroup, this.calculus.getLeveling(), transition);
                reverseTranslatedResult = (int)(this.histoSettlement.reverseTranslateValue(this.calculus.isUnsigned() ? Math.abs(deltaValue) : deltaValue) * 1000.0);
            } else if (calculusType == CalculusTypes.DELTA_PERMILLE) {
                double deltaValue = this.calculateLevelDelta(this.recordGroup, this.calculus.getLeveling(), transition);
                reverseTranslatedResult = (int)(this.histoSettlement.reverseTranslateValue(this.calculus.isUnsigned() ? Math.abs(deltaValue) : deltaValue) * 1000.0 * 1000.0);
            } else if (calculusType == CalculusTypes.RELATIVE_DELTA_PERCENT) {
                double relativeDeltaValue = this.calculateLevelDelta(this.recordGroup, this.calculus.getLeveling(), transition) / (this.recordGroup.getRealMax() - this.recordGroup.getRealMin());
                reverseTranslatedResult = (int)(this.calculus.isUnsigned() ? Math.abs(relativeDeltaValue) * 1000.0 * 100.0 : relativeDeltaValue * 1000.0 * 100.0);
            } else if (calculusType == CalculusTypes.RATIO || calculusType == CalculusTypes.RATIO_PERMILLE) {
                double denominator = this.calculateLevelDelta(this.recordGroup, this.calculus.getLeveling(), transition);
                RecordGroup divisorRecordGroup = new RecordGroup(this.histoSettlement, this.logChannel.getReferenceGroupById(this.calculus.getReferenceGroupIdDivisor()), this.analyzer);
                if (!divisorRecordGroup.hasReasonableData()) {
                    return;
                }
                double divisor = this.calculateLevelDelta(divisorRecordGroup, this.calculus.getDivisorLeveling(), transition);
                log.finer(() -> this.recordGroup.getComment() + " denominator " + denominator + " divisor " + divisor);
                reverseTranslatedResult = calculusType == CalculusTypes.RATIO ? (int)(this.calculus.isUnsigned() ? Math.abs(denominator / divisor * 1000.0) : denominator / divisor * 1000.0) : (int)(this.calculus.isUnsigned() ? Math.abs(denominator / divisor * 1000.0 * 1000.0) : denominator / divisor * 1000.0 * 1000.0);
            } else {
                boolean reverseTranslatedResult2 = false;
                throw new UnsupportedOperationException();
            }
            this.histoSettlement.add((Integer)reverseTranslatedResult, transition);
            log.fine(() -> String.format("%s: timeStamp_ms=%d  reverseTranslatedResult=%d  calcType=%s", new Object[]{this.histoSettlement.getName(), (int)this.histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1), reverseTranslatedResult, calculusType}));
        }
    }

    private double calculateLevelDelta(RecordGroup tmpRecordGroup, LevelingTypes leveling, Transition transition) {
        double deltaValue;
        DeltaLevelCalculator deltaLevelCalculator = new DeltaLevelCalculator(this.calculus.getDeltaBasis(), tmpRecordGroup, transition, this.analyzer);
        if (leveling == LevelingTypes.FIRST) {
            deltaValue = deltaLevelCalculator.calcFirst();
        } else if (leveling == LevelingTypes.LAST) {
            deltaValue = deltaLevelCalculator.calcLast();
        } else if (leveling == LevelingTypes.MID) {
            deltaValue = deltaLevelCalculator.calcMid();
        } else if (leveling == LevelingTypes.AVG) {
            deltaValue = deltaLevelCalculator.calcAvg();
        } else if (leveling == LevelingTypes.MINMAX) {
            deltaValue = deltaLevelCalculator.calcMinMax();
        } else if (leveling == LevelingTypes.SMOOTH_MINMAX) {
            deltaValue = deltaLevelCalculator.calcSmoothMinMax();
        } else {
            throw new UnsupportedOperationException();
        }
        return deltaValue;
    }

    private static class DeltaLevelCalculator {
        private final DeltaBasisTypes deltaBasis;
        private final RecordGroup tmpRecordGroup;
        private final Transition transition;
        private final Analyzer analyzer;

        public DeltaLevelCalculator(DeltaBasisTypes deltaBasis, RecordGroup tmpRecordGroup, Transition transition, Analyzer analyzer) {
            this.deltaBasis = deltaBasis;
            this.tmpRecordGroup = tmpRecordGroup;
            this.transition = transition;
            this.analyzer = analyzer;
        }

        public double calcFirst() {
            Double aggregatedValue;
            int j;
            double referenceExtremum = 0.0;
            double thresholdExtremum = 0.0;
            double recoveryExtremum = 0.0;
            for (j = this.transition.getReferenceStartIndex(); j < this.transition.getReferenceEndIndex() + 1; ++j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                referenceExtremum = aggregatedValue;
                break;
            }
            for (j = this.transition.getThresholdStartIndex() - 1; j < this.transition.getThresholdEndIndex() + 1 + 1; ++j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                thresholdExtremum = aggregatedValue;
                break;
            }
            if (this.transition.getRecoveryStartIndex() > 0) {
                for (j = this.transition.getRecoveryStartIndex(); j < this.transition.getRecoveryEndIndex() + 1; ++j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue == null) continue;
                    recoveryExtremum = aggregatedValue;
                    break;
                }
            }
            double deltaValue = this.calcDeltaValue(this.isPositiveTransition(), referenceExtremum, thresholdExtremum, recoveryExtremum);
            return deltaValue;
        }

        public double calcLast() {
            Double aggregatedValue;
            int j;
            double referenceExtremum = 0.0;
            double thresholdExtremum = 0.0;
            double recoveryExtremum = 0.0;
            for (j = this.transition.getReferenceEndIndex(); j >= this.transition.getReferenceStartIndex(); --j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                referenceExtremum = aggregatedValue;
                break;
            }
            for (j = this.transition.getThresholdEndIndex() + 1; j >= this.transition.getThresholdStartIndex() - 1; --j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                thresholdExtremum = aggregatedValue;
                break;
            }
            if (this.transition.getRecoveryStartIndex() > 0) {
                for (j = this.transition.getRecoveryEndIndex(); j >= this.transition.getRecoveryStartIndex(); --j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue == null) continue;
                    recoveryExtremum = aggregatedValue;
                    break;
                }
            }
            double deltaValue = this.calcDeltaValue(this.isPositiveTransition(), referenceExtremum, thresholdExtremum, recoveryExtremum);
            return deltaValue;
        }

        public double calcMid() {
            Double aggregatedValue;
            int j;
            int i;
            int midIndex;
            double referenceExtremum = 0.0;
            double thresholdExtremum = 0.0;
            double recoveryExtremum = 0.0;
            if (this.transition.getReferenceSize() > 1) {
                i = midIndex = (this.transition.getReferenceStartIndex() + this.transition.getReferenceEndIndex()) / 2;
                for (j = midIndex + 1; i <= this.transition.getReferenceEndIndex() && j >= this.transition.getReferenceStartIndex(); ++i, --j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(i);
                    if (aggregatedValue != null) {
                        referenceExtremum = aggregatedValue;
                    } else {
                        aggregatedValue = this.tmpRecordGroup.getReal(j);
                        if (aggregatedValue == null) continue;
                        referenceExtremum = aggregatedValue;
                    }
                    break;
                }
            } else {
                referenceExtremum = this.tmpRecordGroup.getReal(this.transition.getReferenceStartIndex());
            }
            if (this.transition.getThresholdSize() > 1) {
                i = midIndex = (this.transition.getThresholdStartIndex() + this.transition.getThresholdEndIndex()) / 2;
                for (j = midIndex; i <= this.transition.getThresholdEndIndex() && j >= this.transition.getThresholdStartIndex(); --j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(i);
                    if (aggregatedValue != null) {
                        thresholdExtremum = aggregatedValue;
                    } else {
                        aggregatedValue = this.tmpRecordGroup.getReal(j);
                        if (aggregatedValue == null) continue;
                        thresholdExtremum = aggregatedValue;
                    }
                    break;
                }
            } else {
                thresholdExtremum = this.tmpRecordGroup.getReal(this.transition.getThresholdStartIndex());
            }
            if (this.transition.getRecoveryStartIndex() > 0) {
                if (this.transition.getRecoverySize() > 1) {
                    i = midIndex = (this.transition.getRecoveryStartIndex() + this.transition.getRecoveryEndIndex()) / 2;
                    for (j = midIndex; i <= this.transition.getRecoveryEndIndex() && j >= this.transition.getRecoveryStartIndex(); --j) {
                        aggregatedValue = this.tmpRecordGroup.getReal(i);
                        if (aggregatedValue != null) {
                            recoveryExtremum = aggregatedValue;
                        } else {
                            aggregatedValue = this.tmpRecordGroup.getReal(j);
                            if (aggregatedValue == null) continue;
                            recoveryExtremum = aggregatedValue;
                        }
                        break;
                    }
                } else {
                    recoveryExtremum = this.tmpRecordGroup.getReal(this.transition.getRecoveryStartIndex());
                }
            }
            double deltaValue = this.calcDeltaValue(this.isPositiveTransition(), referenceExtremum, thresholdExtremum, recoveryExtremum);
            return deltaValue;
        }

        public double calcAvg() {
            Double aggregatedValue;
            int j;
            double referenceExtremum = 0.0;
            double thresholdExtremum = 0.0;
            double recoveryExtremum = 0.0;
            double value = 0.0;
            int skipCount = 0;
            for (j = this.transition.getReferenceStartIndex(); j < this.transition.getReferenceEndIndex() + 1; ++j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue != null) {
                    value += (aggregatedValue - value) / (double)(j - this.transition.getReferenceStartIndex() + 1);
                    continue;
                }
                ++skipCount;
            }
            referenceExtremum = value / (double)(this.transition.getReferenceSize() - skipCount);
            value = 0.0;
            skipCount = 0;
            for (j = this.transition.getThresholdStartIndex() - 1; j < this.transition.getThresholdEndIndex() + 1 + 1; ++j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue != null) {
                    value += (aggregatedValue - value) / (double)(j - this.transition.getThresholdStartIndex() + 1);
                    continue;
                }
                ++skipCount;
            }
            thresholdExtremum = value / (double)(this.transition.getThresholdSize() - skipCount);
            if (this.transition.getRecoveryStartIndex() > 0) {
                value = 0.0;
                skipCount = 0;
                for (j = this.transition.getRecoveryStartIndex(); j < this.transition.getRecoveryEndIndex() + 1; ++j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue != null) {
                        value += (aggregatedValue - value) / (double)(j - this.transition.getRecoveryStartIndex() + 1);
                        continue;
                    }
                    ++skipCount;
                }
                recoveryExtremum = value / (double)(this.transition.getRecoverySize() - skipCount);
            }
            double deltaValue = this.calcDeltaValue(this.isPositiveTransition(), referenceExtremum, thresholdExtremum, recoveryExtremum);
            return deltaValue;
        }

        public double calcMinMax() {
            double referenceExtremum = 0.0;
            double thresholdExtremum = 0.0;
            double recoveryExtremum = 0.0;
            boolean isPositiveDirection = this.isPositiveTransition();
            if (isPositiveDirection) {
                Double aggregatedValue;
                int j;
                referenceExtremum = Double.MAX_VALUE;
                for (j = this.transition.getReferenceStartIndex(); j < this.transition.getReferenceEndIndex() + 1; ++j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue < referenceExtremum)) continue;
                    referenceExtremum = aggregatedValue;
                }
                thresholdExtremum = -1.7976931348623157E308;
                for (j = this.transition.getThresholdStartIndex() - 1; j < this.transition.getThresholdEndIndex() + 1 + 1; ++j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue > thresholdExtremum)) continue;
                    thresholdExtremum = aggregatedValue;
                }
                if (this.transition.getRecoveryStartIndex() > 0) {
                    recoveryExtremum = Double.MAX_VALUE;
                    for (j = this.transition.getRecoveryStartIndex(); j < this.transition.getRecoveryEndIndex() + 1; ++j) {
                        aggregatedValue = this.tmpRecordGroup.getReal(j);
                        if (aggregatedValue == null || !(aggregatedValue < recoveryExtremum)) continue;
                        recoveryExtremum = aggregatedValue;
                    }
                }
            } else {
                Double aggregatedValue;
                int j;
                referenceExtremum = -1.7976931348623157E308;
                for (j = this.transition.getReferenceStartIndex(); j < this.transition.getReferenceEndIndex() + 1; ++j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue > referenceExtremum)) continue;
                    referenceExtremum = aggregatedValue;
                }
                thresholdExtremum = Double.MAX_VALUE;
                for (j = this.transition.getThresholdStartIndex() - 1; j < this.transition.getThresholdEndIndex() + 1 + 1; ++j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue < thresholdExtremum)) continue;
                    thresholdExtremum = aggregatedValue;
                }
                if (this.transition.getRecoveryStartIndex() > 0) {
                    recoveryExtremum = -1.7976931348623157E308;
                    for (j = this.transition.getRecoveryStartIndex(); j < this.transition.getRecoveryEndIndex() + 1; ++j) {
                        aggregatedValue = this.tmpRecordGroup.getReal(j);
                        if (aggregatedValue == null || !(aggregatedValue > recoveryExtremum)) continue;
                        recoveryExtremum = aggregatedValue;
                    }
                }
            }
            double deltaValue = this.calcDeltaValue(isPositiveDirection, referenceExtremum, thresholdExtremum, recoveryExtremum);
            return deltaValue;
        }

        public double calcSmoothMinMax() {
            Double aggregatedValue;
            double referenceExtremum = 0.0;
            double thresholdExtremum = 0.0;
            double recoveryExtremum = 0.0;
            boolean isPositiveDirection = this.isPositiveTransition();
            IDevice device = this.analyzer.getActiveDevice();
            Settings settings = this.analyzer.getSettings();
            ChannelPropertyType channelProperty = device.getDeviceConfiguration().getChannelProperty(ChannelPropertyTypes.OUTLIER_SIGMA);
            double sigmaFactor = channelProperty.getValue() != null && !channelProperty.getValue().isEmpty() ? Double.parseDouble(channelProperty.getValue()) : 3.0;
            ChannelPropertyType channelProperty2 = device.getDeviceConfiguration().getChannelProperty(ChannelPropertyTypes.OUTLIER_RANGE_FACTOR);
            double outlierFactor = channelProperty2.getValue() != null && !channelProperty2.getValue().isEmpty() ? Double.parseDouble(channelProperty2.getValue()) : 2.0;
            double probabilityCutPoint = !isPositiveDirection ? 1.0 - settings.getMinmaxQuantileDistance() : settings.getMinmaxQuantileDistance();
            ArrayList<Double> values = new ArrayList<Double>();
            for (int j = this.transition.getReferenceStartIndex(); j < this.transition.getReferenceEndIndex() + 1; ++j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                values.add(aggregatedValue);
            }
            UniversalQuantile tmpQuantile = new UniversalQuantile(values, true, sigmaFactor, outlierFactor, settings);
            referenceExtremum = tmpQuantile.getQuantile(probabilityCutPoint);
            log.fine(() -> "reference " + Arrays.toString(values.toArray()));
            values = new ArrayList();
            for (int j = this.transition.getThresholdStartIndex() - 1; j < this.transition.getThresholdEndIndex() + 1 + 1; ++j) {
                aggregatedValue = this.tmpRecordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                values.add(aggregatedValue);
            }
            tmpQuantile = new UniversalQuantile(values, true, sigmaFactor, outlierFactor, settings);
            thresholdExtremum = tmpQuantile.getQuantile(isPositiveDirection ? 1.0 - settings.getMinmaxQuantileDistance() : settings.getMinmaxQuantileDistance());
            log.fine(() -> "threshold " + Arrays.toString(values.toArray()));
            if (this.transition.getRecoveryStartIndex() > 0) {
                values = new ArrayList();
                for (int j = this.transition.getRecoveryStartIndex(); j < this.transition.getRecoveryEndIndex() + 1; ++j) {
                    aggregatedValue = this.tmpRecordGroup.getReal(j);
                    if (aggregatedValue == null) continue;
                    values.add(aggregatedValue);
                }
                tmpQuantile = new UniversalQuantile(values, true, sigmaFactor, outlierFactor, settings);
                recoveryExtremum = tmpQuantile.getQuantile(probabilityCutPoint);
                log.fine(() -> "recovery " + Arrays.toString(values.toArray()));
            }
            double deltaValue = this.calcDeltaValue(isPositiveDirection, referenceExtremum, thresholdExtremum, recoveryExtremum);
            return deltaValue;
        }

        private double calcDeltaValue(boolean isPositiveDirection, double referenceExtremum, double thresholdExtremum, double recoveryExtremum) {
            double deltaValue;
            if (this.transition.isSlope() || this.deltaBasis == null || this.deltaBasis == DeltaBasisTypes.REFERENCE) {
                deltaValue = thresholdExtremum - referenceExtremum;
            } else if (this.deltaBasis == DeltaBasisTypes.RECOVERY) {
                deltaValue = thresholdExtremum - recoveryExtremum;
            } else if (this.deltaBasis == DeltaBasisTypes.BOTH_AVG) {
                deltaValue = thresholdExtremum - (referenceExtremum + recoveryExtremum) / 2.0;
            } else if (this.deltaBasis == DeltaBasisTypes.INNER) {
                deltaValue = isPositiveDirection ? thresholdExtremum - Math.max(referenceExtremum, recoveryExtremum) : thresholdExtremum - Math.min(referenceExtremum, recoveryExtremum);
            } else if (this.deltaBasis == DeltaBasisTypes.OUTER) {
                deltaValue = isPositiveDirection ? thresholdExtremum - Math.min(referenceExtremum, recoveryExtremum) : thresholdExtremum - Math.max(referenceExtremum, recoveryExtremum);
            } else {
                throw new UnsupportedOperationException();
            }
            log.fine(() -> String.format("referenceExtremum=%f  thresholdExtremum=%f  recoveryExtremum=%f  deltaValue=%f  @ isBasedOnRecovery=%s", new Object[]{referenceExtremum, thresholdExtremum, recoveryExtremum, deltaValue, this.deltaBasis}));
            return deltaValue;
        }

        private boolean isPositiveTransition() {
            int toIndex;
            int fromIndex;
            SingleResponseRegression regression;
            boolean isPositiveDirection = this.transition.isSlope() ? (regression = new SingleResponseRegression(this.tmpRecordGroup.getSubPoints(fromIndex = this.transition.getReferenceStartIndex(), toIndex = this.transition.getThresholdEndIndex() + 1), SingleResponseRegression.RegressionType.LINEAR)).getSlope() > 0.0 : (regression = new SingleResponseRegression(this.tmpRecordGroup.getSubPoints(fromIndex = this.transition.getReferenceStartIndex(), toIndex = this.transition.getRecoveryEndIndex() + 1), SingleResponseRegression.RegressionType.QUADRATIC)).getGamma() < 0.0;
            log.log(Level.FINER, "direction: ", isPositiveDirection);
            return isPositiveDirection;
        }
    }
}

