/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.config.Settings;
import gde.device.IDevice;
import gde.exception.ThrowableUtils;
import gde.histo.device.IHistoDevice;
import gde.log.Logger;
import gde.messages.Messages;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SourceFolders {
    private static final String $CLASS_NAME = SourceFolders.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final Map<DirectoryType, Set<Path>> folders = new EnumMap<DirectoryType, Set<Path>>(DirectoryType.class){
        private static final long serialVersionUID = -8624409377603884008L;

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Map that = (Map)obj;
            boolean hasSameDirectoryTypes = this.keySet().equals(that.keySet());
            if (hasSameDirectoryTypes) {
                Set thatSet;
                Map.Entry entry;
                Set thisSet;
                boolean isEqual = true;
                Iterator iterator = this.entrySet().iterator();
                while (iterator.hasNext() && (isEqual &= (thisSet = (Set)(entry = iterator.next()).getValue()).equals(thatSet = (Set)that.get(entry.getKey())))) {
                }
                log.log(Level.FINEST, "isEqual=", isEqual);
                return isEqual;
            }
            return false;
        }
    };
    private final Analyzer analyzer;

    public SourceFolders(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void defineDirectories(Consumer<String> signaler) {
        this.folders.clear();
        IDevice device = this.analyzer.getActiveDevice();
        Settings settings = this.analyzer.getSettings();
        for (DirectoryType directoryType : DirectoryType.getValidDirectoryTypes(device, settings)) {
            signaler.accept("find object folders for " + String.valueOf((Object)directoryType));
            Set<Path> currentPaths = this.defineCurrentPaths(directoryType);
            signaler.accept("");
            if (!settings.getActiveObjectKey().isEmpty()) {
                Set externalObjectPaths = directoryType.getExternalBaseDirs(this.analyzer.getSettings()).map(p -> this.defineObjectPaths((Path)p)).flatMap(Collection::stream).collect(Collectors.toSet());
                currentPaths.addAll(externalObjectPaths);
                log.log(Level.FINE, directoryType.toString(), externalObjectPaths);
            }
            log.log(Level.FINE, directoryType.toString(), currentPaths);
            this.folders.put(directoryType, currentPaths);
        }
    }

    private void removeDoubleDirectories() {
    }

    private Set<Path> defineCurrentPaths(DirectoryType directoryType) {
        Set<Path> newPaths = new HashSet<Path>();
        Path basePath = directoryType.getBasePath(this.analyzer.getSettings().getDataFilePath());
        if (basePath != null) {
            if (this.analyzer.getSettings().getActiveObjectKey().isEmpty()) {
                IDevice device = this.analyzer.getActiveDevice();
                Path rootPath = directoryType.getDeviceSubPath(device) != null ? basePath.resolve(directoryType.getDeviceSubPath(device)) : basePath;
                newPaths.add(rootPath);
            } else {
                newPaths = this.defineObjectPaths(basePath);
            }
        }
        return newPaths;
    }

    private Set<Path> defineObjectPaths(Path basePath) {
        Set<Path> paths = new HashSet<Path>();
        Stream<String> objectKeys = Stream.of(this.analyzer.getSettings().getActiveObjectKey());
        try (Stream<Path> objectPaths = this.analyzer.getDataAccess().getSourceFolders(basePath, objectKeys);){
            paths = objectPaths.collect(Collectors.toSet());
        }
        catch (IOException | UncheckedIOException e) {
            log.log(Level.SEVERE, e.getMessage(), " is not accessible : " + String.valueOf(e.getClass()));
            if (e.getMessage().replace('\\', '/').contains(this.analyzer.getSettings().getDataFilePath())) {
                ThrowableUtils.rethrow(e);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        return paths;
    }

    public Set<Map.Entry<DirectoryType, Set<Path>>> entrySet() {
        return this.folders.entrySet();
    }

    public Collection<Set<Path>> values() {
        return this.folders.values();
    }

    public Map<Path, Set<DirectoryType>> getMap() {
        HashMap<Path, Set<DirectoryType>> directoryTypesMap = new HashMap<Path, Set<DirectoryType>>();
        for (Map.Entry<DirectoryType, Set<Path>> entry : this.folders.entrySet()) {
            for (Path path : entry.getValue()) {
                EnumSet<DirectoryType> set = (EnumSet<DirectoryType>)directoryTypesMap.get(path);
                if (set == null) {
                    set = EnumSet.noneOf(DirectoryType.class);
                    directoryTypesMap.put(path, set);
                }
                set.add(entry.getKey());
            }
        }
        return directoryTypesMap;
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.folders == null ? 0 : this.folders.hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceFolders other = (SourceFolders)obj;
        return !(this.folders == null ? other.folders != null : !this.folders.equals(other.folders));
    }

    public String toString() {
        return String.valueOf(this.folders);
    }

    public int getFoldersCount() {
        return this.values().parallelStream().mapToInt(Collection::size).sum();
    }

    public String getTruncatedFileNamesCsv() {
        String ellipsisText = Messages.getString("GDE_MSGT0864");
        return this.folders.values().stream().flatMap(Collection::stream).map(Path::getFileName).map(Path::toString).map(s -> s.length() > 22 ? s.substring(0, 22) + ellipsisText : s).distinct().collect(Collectors.joining(","));
    }

    public String getDecoratedPathsCsv() {
        ArrayList<String> directoryTypeTexts = new ArrayList<String>();
        for (Map.Entry<DirectoryType, Set<Path>> directoryEntry : this.folders.entrySet()) {
            String text = directoryEntry.getValue().stream().map(Path::toString).map(p -> ((DirectoryType)((Object)((Object)directoryEntry.getKey()))).toString() + " : " + p).collect(Collectors.joining(","));
            directoryTypeTexts.add(text);
        }
        return directoryTypeTexts.stream().collect(Collectors.joining(","));
    }

    public boolean isMatchingPath(Path sourceFile) {
        int nameCountMax = this.analyzer.getSettings().getSubDirectoryLevelMax() + 1;
        Map<Path, Set<DirectoryType>> pathMap = this.getMap();
        for (Path path : pathMap.keySet()) {
            try {
                if (path.relativize(sourceFile).getNameCount() > nameCountMax) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DirectoryType {
        DATA{

            @Override
            public Path getBasePath(String dataFilePath) {
                return dataFilePath == null || dataFilePath.isEmpty() ? null : Paths.get(dataFilePath, new String[0]);
            }

            @Override
            public Path getDeviceSubPath(IDevice device) {
                return Paths.get(device.getDeviceConfiguration().getPureDeviceName(device.getName()), new String[0]);
            }

            @Override
            public List<String> getDataSetExtentions(IDevice device, Settings settings) {
                ArrayList<String> extentions = new ArrayList<String>();
                extentions.add(".osd");
                if (device instanceof IHistoDevice && settings.getSearchDataPathImports()) {
                    extentions.addAll(((IHistoDevice)((Object)device)).getSupportedImportExtentions());
                }
                return extentions;
            }

            @Override
            public Stream<Path> getExternalBaseDirs(Settings settings) {
                try {
                    return Arrays.stream(settings.getDataFoldersCsv().split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0]));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    return Stream.empty();
                }
            }

            @Override
            public boolean isActive(IDevice device, Settings settings) {
                return true;
            }
        }
        ,
        IMPORT{

            @Override
            @Nullable
            public Path getBasePath(String dataFilePath) {
                return null;
            }

            @Override
            public Path getDeviceSubPath(IDevice device) {
                return null;
            }

            @Override
            public List<String> getDataSetExtentions(IDevice device, Settings settings) {
                if (device instanceof IHistoDevice) {
                    return ((IHistoDevice)((Object)device)).getSupportedImportExtentions();
                }
                return new ArrayList<String>();
            }

            @Override
            public Stream<Path> getExternalBaseDirs(Settings settings) {
                try {
                    return Arrays.stream(settings.getImportFoldersCsv().split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0]));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    return Stream.empty();
                }
            }

            @Override
            public boolean isActive(IDevice device, Settings settings) {
                log.finest(() -> " IMPORT : Extensions.isEmpty=" + this.getDataSetExtentions(device, settings).isEmpty() + " ExternalFolders.exist=" + this.getExternalBaseDirs(settings).anyMatch(e -> true));
                if (this.getDataSetExtentions(device, settings).isEmpty()) {
                    return false;
                }
                return this.getExternalBaseDirs(settings).anyMatch(e -> true);
            }
        };

        public static final DirectoryType[] VALUES;

        public static EnumSet<DirectoryType> getValidDirectoryTypes(IDevice device, Settings settings) {
            EnumSet<DirectoryType> directoryTypes = EnumSet.noneOf(DirectoryType.class);
            for (DirectoryType directoryType : VALUES) {
                if (!directoryType.isActive(device, settings)) continue;
                directoryTypes.add(directoryType);
            }
            return directoryTypes;
        }

        @Nullable
        public abstract Path getBasePath(String var1);

        @Nullable
        public abstract Path getDeviceSubPath(IDevice var1);

        public abstract List<String> getDataSetExtentions(IDevice var1, Settings var2);

        public abstract boolean isActive(IDevice var1, Settings var2);

        public abstract Stream<Path> getExternalBaseDirs(Settings var1);

        static {
            VALUES = DirectoryType.values();
        }
    }
}

