/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime.property;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.DomHandler;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.glassfish.jaxb.core.v2.ClassFactory;
import org.glassfish.jaxb.core.v2.model.core.PropertyKind;
import org.glassfish.jaxb.core.v2.model.core.WildcardMode;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimeElement;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimeReferencePropertyInfo;
import org.glassfish.jaxb.runtime.v2.runtime.JAXBContextImpl;
import org.glassfish.jaxb.runtime.v2.runtime.JaxBeanInfo;
import org.glassfish.jaxb.runtime.v2.runtime.XMLSerializer;
import org.glassfish.jaxb.runtime.v2.runtime.property.ArrayERProperty;
import org.glassfish.jaxb.runtime.v2.runtime.property.UnmarshallerChain;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Accessor;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.ListIterator;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.ChildLoader;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.Loader;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.Receiver;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.UnmarshallingContext;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.WildcardLoader;
import org.glassfish.jaxb.runtime.v2.util.QNameMap;
import org.xml.sax.SAXException;

class ArrayReferenceNodeProperty<BeanT, ListT, ItemT>
extends ArrayERProperty<BeanT, ListT, ItemT> {
    private final QNameMap<JaxBeanInfo> expectedElements = new QNameMap();
    private final boolean isMixed;
    private final DomHandler domHandler;
    private final WildcardMode wcMode;

    public ArrayReferenceNodeProperty(JAXBContextImpl p2, RuntimeReferencePropertyInfo prop) {
        super(p2, prop, prop.getXmlName(), prop.isCollectionNillable());
        for (RuntimeElement runtimeElement : prop.getElements()) {
            JaxBeanInfo bi = p2.getOrCreate(runtimeElement);
            this.expectedElements.put(runtimeElement.getElementName().getNamespaceURI(), runtimeElement.getElementName().getLocalPart(), bi);
        }
        this.isMixed = prop.isMixed();
        if (prop.getWildcard() != null) {
            this.domHandler = (DomHandler)ClassFactory.create((Class)prop.getDOMHandler());
            this.wcMode = prop.getWildcard();
        } else {
            this.domHandler = null;
            this.wcMode = null;
        }
    }

    @Override
    protected final void serializeListBody(BeanT o2, XMLSerializer w2, ListT list2) throws IOException, XMLStreamException, SAXException {
        ListIterator itr = this.lister.iterator(list2, w2);
        while (itr.hasNext()) {
            try {
                Object item2 = itr.next();
                if (item2 == null) continue;
                if (this.isMixed && item2.getClass() == String.class) {
                    w2.text((String)item2, null);
                    continue;
                }
                JaxBeanInfo bi = w2.grammar.getBeanInfo(item2, true);
                if (bi.jaxbType == Object.class && this.domHandler != null) {
                    w2.writeDom(item2, this.domHandler, o2, this.fieldName);
                    continue;
                }
                bi.serializeRoot(item2, w2);
            }
            catch (JAXBException e2) {
                w2.reportError(this.fieldName, e2);
            }
        }
    }

    @Override
    public void createBodyUnmarshaller(UnmarshallerChain chain, QNameMap<ChildLoader> loaders) {
        int offset = chain.allocateOffset();
        ArrayERProperty.ReceiverImpl recv = new ArrayERProperty.ReceiverImpl(offset);
        for (QNameMap.Entry<JaxBeanInfo> n2 : this.expectedElements.entrySet()) {
            JaxBeanInfo beanInfo = n2.getValue();
            loaders.put(n2.nsUri, n2.localName, new ChildLoader(beanInfo.getLoader(chain.context, true), recv));
        }
        if (this.isMixed) {
            loaders.put(TEXT_HANDLER, new ChildLoader(new MixedTextLoader(recv), null));
        }
        if (this.domHandler != null) {
            loaders.put(CATCH_ALL, new ChildLoader(new WildcardLoader(this.domHandler, this.wcMode), recv));
        }
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.REFERENCE;
    }

    @Override
    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        if (this.wrapperTagName != null ? this.wrapperTagName.equals(nsUri, localName) : this.expectedElements.containsKey(nsUri, localName)) {
            return this.acc;
        }
        return null;
    }

    private static final class MixedTextLoader
    extends Loader {
        private final Receiver recv;

        public MixedTextLoader(Receiver recv) {
            super(true);
            this.recv = recv;
        }

        @Override
        public void text(UnmarshallingContext.State state, CharSequence text2) throws SAXException {
            if (text2.length() != 0) {
                this.recv.receive(state, text2.toString());
            }
        }
    }
}

