#!/bin/bash

# Call 'dar' for a complete backup every month and incremental ones
# each day

# Copyright (C) 2005  Cliss XXI
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#
# Author: Sylvain Beucler <beuc@beuc.net>

# ToDo: implement directories per months

remote="root@loos"
day=`date +%d`

function launch_remote_dar() {
    remote_command=$1
    ssh root@loos $remote_command \
	| dar_xform -Q -w -s 1G \
	-E "par2create -qq -r5 %p/%b.%n.%e" \
	- backup/$day
}

# Build the command line
cmd_dar_full="dar -Q --noconf --no-warn \
 --on-fly-isolate /root/cur_dar_cat \
 --fs-root / --prune proc --prune sys \
 -z6 -Z '.zip' -Z '*.gz' -Z '*.bz2' -Z '*.jpg' -Z '*.png' \
 -Z '*.mp3' -Z '*.mpg' \
 --create -"
cmd_dar_incremental="$cmd_dar_full --ref /root/prev_dar_cat"

# Full backup each 1st day of the month
cmd_dar=$cmd_dar_full
if [ $day -ne 1 ]; then
    cmd_dar=$cmd_dar_incremental
fi

# Clean-up (maybe there're still files from last year)
rm backup/$day*

# Launch the backup
launch_remote_dar "$cmd_dar"

# Maybe it failed because there was no catalogue yet
exit_code=$?
if [ $exit_code -eq 2 -a $day -ne 1 ]; then
    echo "dar failed - trying a non-incremental backup instead"
    launch_remote_dar "$cmd_dar_full"
fi

# Place the catalogue for the next call
ssh root@loos "mv /root/cur_dar_cat.1.dar /root/prev_dar_cat.1.dar"
