#!/bin/bash

if [ ! -e /home/password_root.txt \
    -o ! -e /home/password_1000.txt \
    -o ! -e /home/password_1000_username.txt \
    -o ! -e /home/password_1000_fullname.txt \
    ]; then
    echo "Missing /home/*.txt file";
    exit 1;
fi

# RESTORE
rootpass=`cat /home/password_root.txt`
#sed -i -e "s/^root:[^:]*:\(.*\)$/root:$rootpass:\1/" /etc/shadow
usermod -p "$rootpass" root

deluser `getent passwd 1000 | cut -d: -f1`
# Forcibly remove user#1000
# (ie. even if the system thinks it's logged in)
grep -v '^[^:]\+:x:1000:' < /etc/passwd > /etc/passwd.temp
mv /etc/passwd.temp /etc/passwd

delgroup `getent group 1000 | cut -d: -f1`
# Forcibly remove group#1000
grep -v '^[^:]\+:x:1000:' < /etc/group > /etc/group.temp
mv /etc/group.temp /etc/group


chmod 644 /etc/passwd /etc/group



# * Recreate group
groupadd -g 1000 $localuser

# * Recreate user
localuser=`cat /home/password_1000_username.txt`
useradd -u 1000 -g $localuser $localuser
localpass=`cat /home/password_1000.txt`
#sed -i -e "s/^$localuser:[^:]*:\(.*\)$/$localuser:$localpass:\1/" /etc/shadow
usermod -p "$localpass" $localuser
fullname=`cat /home/password_1000_fullname.txt`
chfn -f "$fullname" $localuser
# Explicit shell, to have GDM display that user:
chsh -s /bin/bash $localuser
../desktop-group.sh $localuser
