#!/usr/bin/perl
# Get a list of Debian HTTP mirrors grouped by country code

# Copyright (C) 2006  Sylvain Beucler <beuc@beuc.net>
# Based on public domain code from netselect-apt
#   by Avery Pennarun and Filippo Giunchedi

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

# Get the mirror list from:
# wget http://www.debian.org/mirror/list-full

open(LIST, '< ./list-full');
$/="\n\n";
$cur_country = '';
while(<LIST>) {
    next if $_ !~ /Site:/;
    if (($_ =~ /Archive Architectures:.* i386( |\n)/i
	 or $_ !~ /Archive Architectures:/)) {
	if (m@Packages over HTTP:.*<a href="(http://.*?)">@i) {
	    $mirror = $1;
	    $cur_contry = $1 if (/<strong><a name="(..)"/);
	    print "$cur_contry\t$mirror\n";
	}
    }
}
close(LIST);
