#!/usr/bin/perl -T
# Debian mirror redirection service

# Copyright (C) 2006  Sylvain Beucler <beuc@beuc.net>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.


# This is a Debian mirror redirection service - you call the script
# and add a path after the script name (PATH_INFO), and the script
# will redirect you to a mirror in your country.

# Your contry is either specified as a PATH_INFO prefix, or it is
# estimated using Geo::IP IP->Country mapping.

# Unfortunately, apt currently does not support redirections:
# https://launchpad.net/distros/ubuntu/+source/apt/+bug/18645
# Consequently this won't work until that issue is resolved.

# Examples:
# Automatic redirection:
# http://localhost/free-documentation.cgi/pool/non-free/t/texinfo-doc-nonfree/texinfo-doc-nonfree_4.8-1.dsc
# -> http://ftp.debian.org/debian/pool/non-free/t/texinfo-doc-nonfree/texinfo-doc-nonfree_4.8-1.dsc
# Explicitely chose a French (FR) mirror:
# http://localhost/free-documentation.cgi/FR/pool/non-free/t/texinfo-doc-nonfree/texinfo-doc-nonfree_4.8-1.dsc
# -> http://ftp.nerim.net/debian/pool/non-free/t/texinfo-doc-nonfree/texinfo-doc-nonfree_4.8-1.dsc

# Add ?debug=1 at the end of the URL to print the direction instead of
# actually getting redirected (useful for tests)

use Geo::IP;
use strict;
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);

sub parse_mirrors {
    my %mirrors = {};
    open(MIRRORS, '< mirrors.tsv');
    while(<MIRRORS>) {
	chomp; # avoid \n on last field
	my ($country, $url) = split("\t");
	push(@{$mirrors{$country}}, $url);
    }
    close(MIRRORS);
    return %mirrors;
}

my $country;

my $path = $ENV{'PATH_INFO'};
$path =~ s,^/,,; # remove first slash
if ($path =~ m:^([A-Z]{2})/:) { # country code
    $country = $1;
    $path = $'; # rest for the string '
}

if (!defined($country)) {
    my $gi = Geo::IP->new(GEOIP_STANDARD);
    $country = $gi->country_code_by_addr($ENV{'REMOTE_ADDR'});
}

my $mirror = 'http://ftp.debian.org/debian/';
if (defined($country)) {
    my %mirrors = &parse_mirrors();
    if (defined(@{$mirrors{$country}})) {
	my $nb_mirrors = scalar(@{$mirrors{$country}});
	my $random = int(rand($nb_mirrors));
	$mirror = @{$mirrors{$country}}[$random];
    } else {
	print "Status: 404 Not Found\n";
	print "Content-type: text/html\n\n";
	print "Error: Unknown country code!";
	exit;
    }
}

if (param('debug')) {
    print "Content-type: text/html\n\n";
    print "IP: $ENV{'REMOTE_ADDR'}<br />";
    print "Country: $country<br />";
    print "Location: $mirror$path\n";
    exit;
}

# Redirect to the mirror
print "Location: $mirror$path\n\n";
