#!/bin/bash
# Graphical interface to convert a PDF to a 2-per-page PostScript

# Copyright (C) 2006  Cliss XXI
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#
# Author: Sylvain Beucler <beuc@beuc.net>

# Depends: xdialog, psutils, xpdf-utils

title='2/page'

if [ -z $1 ]; then
    Xdialog --title $title --msgbox 'Veuillez glisser/déposer un PDF sur le lanceur.' 5 50
    exit 1
fi

suggested_output=`echo $1 | sed 's/\.[^.]*$/-2parPage.ps/'`
output=`Xdialog --stdout --title "$title - Enregistrer sous..." --fselect "$suggested_output" 30 100`
ret=$?

if [ $ret -eq 0 ]; then
    pdftops $1 - | psnup -2 > $output
    Xdialog --title $title --msgbox "$output créé." 5 50
else
    Xdialog --title $title --msgbox "Opération annulée." 5 30
fi

