// Dezyne --- Dezyne command line tools
//
// Copyright © 2016 Paul Hoogendijk <paul@dezyne.org>
// Copyright © 2018, 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
// Copyright © 2017, 2018, 2020 Rutger van Beusekom <rutger@dezyne.org>
//
// This file is part of Dezyne.
//
// Dezyne is free software: you can redistribute it and/or modify it
// under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// Dezyne is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public
// License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.
//
// Commentary:
//
// Code:

#include "async_ranking.hh"

#include <dzn/locator.hh>
#include <dzn/runtime.hh>
#include <dzn/pump.hh>

#include <future>
#include <iostream>
#include <limits>

int main()
{
  std::cin.ignore(std::numeric_limits<std::streamsize>::max());

  struct C {
    dzn::locator loc;
    dzn::runtime rt;
    async_ranking sut;
    dzn::pump pump;

    C()
    : sut(loc.set(rt).set(pump))
    , pump()
    {}
  };

  C c;

  dzn::apply(&c.sut.dzn_meta, [](const dzn::meta* m){std::cout << m->parent << " " << m << " " << m->name << " " << m->rank << std::endl;});

  c.sut.dzn_meta.name = "sut";
  c.sut.p.meta.require.port = "p";

  c.sut.p.out.done = [] {std::clog << "sut.p.done -> <external>.p.done" << std::endl;};

  dzn::shell(c.pump, c.sut.p.in.doAB);
  dzn::shell(c.pump, c.sut.p.in.doBA);
}
