// Dezyne --- Dezyne command line tools
//
// Copyright © 2023 Rutger van Beusekom <rutger@dezyne.org>
//
// This file is part of Dezyne.
//
// Dezyne is free software: you can redistribute it and/or modify it
// under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// Dezyne is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public
// License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.

// Generated by dzn code from test/all/foreign_only/foreign_only.dzn
#include "foreign.hh"
#include <dzn/container.hh>
#include <algorithm>
#include <cstring>
static void
connect_ports (dzn::container< ::foreign, std::function<void ()>>& c)
{
  dzn::debug.rdbuf () && dzn::debug << c.dzn_meta.name << std::endl;
  c.system.port.out.cruel = [&] ()
    {
      c.match ("port.cruel");
    };
  c.system.port.out.world = [&] (int, double)
    {
      c.match ("port.world");
    };
}
static std::map<std::string, std::function<void ()> >
event_map (dzn::container< ::foreign, std::function<void ()>>& c)
{
  c.system.port.dzn_meta.require.component = &c;
  c.system.port.dzn_meta.require.meta = &c.dzn_meta;
  c.system.port.dzn_meta.require.name = "port";
  return   {  {"illegal", []  {std::clog << "illegal" << std::endl;}}
      ,   {"error", []  {std::clog << "sut.error -> sut.error" << std::endl; std::exit (0);}}
      ,   {"port.hello",[&] ()
            {
              c.match ("port.hello");
              c.system.port.in.hello (0, 1);
              c.match ("port.return");
            }}
      ,   {"port.bye",[&] ()
            {
              c.match ("port.bye");
              c.system.port.in.bye ();
              c.match ("port.return");
            }}
      ,   {"port.<flush>",[&] ()
            {
              c.match ("port.<flush>");
              std::clog << "port.<flush>" << std::endl;
              c.dzn_runtime.flush (&c);
            }}};
}
static bool
dzn_getopt (int argc, char const* argv[], std::string option)
{
  return argv + argc != std::find_if (argv + 1, argv + argc, [&option] (char const* s)
    {
      return s == option;
    });
}
int
main (int argc, char const* argv[])
{
  bool flush = dzn_getopt (argc, argv, "--flush");
  if (dzn_getopt (argc, argv, "--debug")) dzn::debug.rdbuf (std::clog.rdbuf ());
  dzn::container< ::foreign, std::function<void ()>> c (flush);
  connect_ports (c);
  c (event_map (c));
}
// version 2.18.0.rc5.70-dfe40
