/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_agfunc.h"

static const char       rcsid[] = "$Id: alloc_func.c,v 1.2 2009/10/16 19:43:49 keith Exp $";

/*
** $Log: alloc_func.c,v $
** Revision 1.2  2009/10/16 19:43:49  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/02 00:53:51  keith
** Initial revision
**
*/

/*
** This function increases size of func_tbl and appends an aggregate function.
*/
int alloc_func( func_t **func_tbl, unsigned short *func_tbl_cnt, func_type_t func_type, const char *src_field_name, const char *result_field_name, const char *output_format )
{
	static const char	func[] = "alloc_func";
	size_t	alloc_size;
	func_t	*new;

	assert( func_tbl != (func_t **)0 );
	assert( func_tbl_cnt != (unsigned short *)0 );
	assert( func_type == Sum || func_type == Average || func_type == Num_min || func_type == Num_max || func_type == Str_min || func_type == Str_max || func_type == Count );
	assert( result_field_name != (const char *)0 );
	/*
	** src_field_name will be null when func_type is Count.
	** output_format is only populated for average and sum.
	*/

	DEBUG_FUNC_START;

	alloc_size = ( (size_t)*func_tbl_cnt + (size_t)1 ) * sizeof( func_t );

	new = (func_t *)realloc( *func_tbl, alloc_size );
	if ( new == (func_t *)0 ) {
		UNIX_ERROR( "realloc() failed" );
		RETURN_INT( -1 );
	}

	*func_tbl = new;
	new = &new[ *func_tbl_cnt ];
	(void) memset( (void *)new, 0, sizeof( func_t ) );

	new->func_type = func_type;
	new->src_field_name = src_field_name;
	new->result_field_name = result_field_name;
	new->output_format = output_format;

	/*
	** Set initialize flag to true.
	*/
	new->initialize_flag = 1;

	++*func_tbl_cnt;

	RETURN_INT( 0 );
}
