/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_agfunc.h"

static const char       rcsid[] = "$Id: main.c,v 1.2 2009/10/16 19:43:49 keith Exp $";

/*
** $Log: main.c,v $
** Revision 1.2  2009/10/16 19:43:49  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/02 04:49:19  keith
** Initial revision
**
*/

/*
** This program performs aggregate functions.
*/
int main( int argc, char **argv )
{
	static const char	func[] = "main";
	const char	*input_dfile_name, *output_dfile_name;
	const char	*key_argument;
	const char	*input_filter_file_name, *output_filter_file_name;
	dfile_t	*output_dfile, *input_dfile;
	int	thread_input_flag, thread_output_flag;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt;
	const char	**key_tbl;
	unsigned long	key_tbl_cnt;
	dfile_bind_t	**input_key_tbl;
	dfile_bind_t	**output_key_tbl;
	func_t	*func_tbl;
	unsigned short	func_tbl_cnt;
	void	*input_filter, *output_filter;

	if ( get_args( argc, argv, &input_dfile_name, &output_dfile_name, &thread_input_flag, &thread_output_flag, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &key_argument, &func_tbl, &func_tbl_cnt, &input_filter_file_name, &output_filter_file_name ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	if ( key_argument == (const char *)0 ) {
		key_tbl = (const char **)0;
		key_tbl_cnt = 0UL;
	} else {
		/*
		** Parse key field names from command line argument.
		*/
		if ( parse_list( &key_tbl, &key_tbl_cnt, key_argument, ',' ) == -1 ) {
			RETURN_INT( 10 );
		}
	}

	if ( open_dfile( &input_dfile, input_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_input_flag, 'r' ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( open_dfile( &output_dfile, output_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_output_flag, 'w' ) == -1 ) {
		RETURN_INT( 30 );
	}

	if ( key_tbl_cnt > (unsigned short)0 ) {
		if ( assign_field_bind( &input_key_tbl, key_tbl, (unsigned short)key_tbl_cnt, input_dfile->bind_hash_table ) == -1 ) {
			RETURN_INT( 35 );
		}

		if ( assign_field_bind( &output_key_tbl, key_tbl, (unsigned short)key_tbl_cnt, output_dfile->bind_hash_table ) == -1 ) {
			RETURN_INT( 40 );
		}
	}

	if ( bind_func( func_tbl, func_tbl_cnt, input_dfile->bind_hash_table, output_dfile->bind_hash_table ) == -1 ) {
		RETURN_INT( 50 );
	}

	if ( compile_filters( &input_filter, &output_filter, input_filter_file_name, output_filter_file_name, input_dfile, output_dfile ) == -1 ) {
		RETURN_INT( 55 );
	}

	if ( process_file( output_dfile, input_dfile, (const dfile_bind_t **)input_key_tbl, output_key_tbl, (unsigned short)key_tbl_cnt, func_tbl, func_tbl_cnt, input_filter, output_filter ) == -1 ) {
		RETURN_INT( 60 );
	}

#if 0
	(void) dfile_read_close( input_dfile );
	(void) dfile_read_close( join_dfile );
#endif

	if ( dfile_write_close( output_dfile ) == -1 ) {
		RETURN_INT( 70 );
	}

	RETURN_INT( 0 );
}
