/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: assign_input_fname.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: assign_input_fname.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 02:46:40  keith
** Initial revision
**
*/

/*
** This function gets a list of input file names to process. Variable
** fname will return a pointer to a null terminated array of pointers.
** The array of pointers point to actual file names. Variable fname_pattern
** contains a file expression with wild card characters to represent
** the group of files to process.
*/
int assign_input_fname( const char ***fname, unsigned short *fname_cnt, const char *fname_pattern )
{
	static const char	func[] = "assign_input_fname";
	const char	**ptr;

	DEBUG_FUNC_START;

	if ( glob_fname( fname, fname_pattern ) == -1 ) {
		RETURN_INT( -1 );
	}

	*fname_cnt = (unsigned short)0;

	for ( ptr = *fname; *ptr != (const char *)0; ++ptr ) {
		++*fname_cnt;
	}

	RETURN_INT( 0 );
}
