/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

/*
**  $Id: dfile_exec.h,v 1.2 2009/10/16 20:05:35 keith Exp $
**
**  $Log: dfile_exec.h,v $
**  Revision 1.2  2009/10/16 20:05:35  keith
**  Added GPL to source code.
**
**  Revision 1.1  2009/03/07 17:01:27  keith
**  Initial revision
**
*/

#define	MAX_ARGS	1024

typedef enum { Invalid_slice_method, Parm_file_slice = 'P', File_slice = 'F' } slice_method_t;

typedef struct job_s	job_t;

struct job_s {
	int	job_nbr;
	pid_t	pid;
	char	**exec_args;
	int	status;
	int	stdout_fd;
	int	stderr_fd;
	unsigned short	attempts;
	job_t	*prev;
	job_t	*next;
};

int get_args( int, char * const [], const char **, unsigned short *, unsigned short *, const char **, const char **, const char **, const char **, unsigned short *, const char ** );
int parse_exec_args( const char *, char *** );
job_t *alloc_job_tbl( unsigned short );
int assign_fname( const char **, const char **, const char *, unsigned short, unsigned short, const char * );
int start_jobs( unsigned short *, unsigned short *, job_t *, void **, const char **, unsigned short, const char * const *, unsigned short, slice_method_t, unsigned short, unsigned short, const char *, int, unsigned short );
pid_t exec_job( char * const *, const char *, const char *, int *, int *, const char * );
int jobcmp( const void *, const void * );
int wait_job( unsigned short *, void **, int *, unsigned short *, job_t **, unsigned short );
int replace_arg_flags( char **, unsigned short, const char * );
int assign_input_fname( const char ***, unsigned short *, const char * );
slice_method_t get_slice_method( unsigned short, const char * );
int get_divvy_text( const char ***, unsigned short *, const char * );
int load_recovery_log( job_t *, unsigned short *, unsigned short, unsigned short, slice_method_t, const char * );
int write_recovery_log( job_t *, unsigned short, unsigned short, slice_method_t, const char * );
int get_job_cnt( unsigned short *, unsigned short, unsigned short, slice_method_t );
int assign_exec_args( const char *, job_t *, const char **, unsigned short, unsigned short, slice_method_t );
int set_job_list( job_t **, job_t *, unsigned short, unsigned short, slice_method_t );
int get_cpu_semid( const char * );
int request_job_resource( int *, unsigned short, int );
int release_allocated_jobs( unsigned short, int );
void write_system_usage( void );
int substitute_tokens( char *, size_t, const char *, const char * );
