/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: get_job_cnt.c,v 1.3 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: get_job_cnt.c,v $
** Revision 1.3  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.2  2009/03/07 04:04:18  keith
** Standardized an error message.
**
** Revision 1.1  2009/03/07 04:01:57  keith
** Initial revision
**
*/

/*
** This function gets a job count based on partition method.
*/
int get_job_cnt( unsigned short *job_cnt, unsigned short range_tbl_cnt, unsigned short input_fname_cnt, slice_method_t slice_method_flag )
{
	static const char	func[] = "get_job_cnt";

	assert( slice_method_flag == File_slice || slice_method_flag == Parm_file_slice );

	DEBUG_FUNC_START;

	switch ( slice_method_flag ) {
	case Parm_file_slice:
		*job_cnt = range_tbl_cnt;
		break;
	case File_slice:
		*job_cnt = input_fname_cnt;
		break;
	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Programming error--unknown slice method encountered.\n", stderr );

		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
