/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: set_job_list.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: set_job_list.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 06:48:24  keith
** Initial revision
**
*/

/*
** This function creates a linked list of job_t structures.
*/
int set_job_list( job_t **job_list, job_t *job_tbl, unsigned short range_tbl_cnt, unsigned short input_fname_cnt, slice_method_t slice_method_flag )
{
	static const char	func[] = "set_job_list";
	unsigned short	job_ndx;
	unsigned short	job_cnt;
	job_t	*job, *trav_job;

	assert( job_list != (job_t **)0 );
	assert( job_tbl != (job_t *)0 );
	assert( slice_method_flag == File_slice || slice_method_flag == Parm_file_slice );

	DEBUG_FUNC_START;

	if ( get_job_cnt( &job_cnt, range_tbl_cnt, input_fname_cnt, slice_method_flag ) == -1 ) {
		RETURN_INT( -1 );
	}

	*job_list = (job_t *)0;
	trav_job = (job_t *)0;

	for ( job_ndx = (unsigned short)0; job_ndx < job_cnt; ++job_ndx ) {
		job = &job_tbl[ job_ndx ];

		if ( job->pid != (pid_t)0 ) {
			/*
			** Job previously ran.
			*/
			continue;
		}

		if ( trav_job == (job_t *)0 ) {
			/*
			** First link in list.
			*/
			*job_list = job;
			trav_job = job;
			trav_job->prev = (job_t *)0;
		} else {
			trav_job->next = job;
			job->prev = trav_job;
			trav_job = job;
		}

		trav_job->next = (job_t *)0;
	}

	RETURN_INT( 0 );
}
