/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: assign_join_dfile.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: assign_join_dfile.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 22:42:47  keith
** Initial revision
**
*/

/*
** This function assigns information from control structure.
*/
int assign_join_dfile( join_ctl_t *join_ctl, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	func[] = "assign_join_dfile";
	int	ret;

	assert( join_ctl != (join_ctl_t *)0 );

	DEBUG_FUNC_START;

	while ( sexpr != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( sexpr ) != list_sexpr ) {
			control_syntax_error( "expected a list", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		ret = assign_join_dfile_attribute( join_ctl, SEXPR_CAR_LIST( sexpr ), tuple_cnt );
		if ( ret != 0 ) {
			RETURN_INT( ret );
		}

		assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

		sexpr = SEXPR_CDR_LIST( sexpr );
	}

	RETURN_INT( 0 );
}
