/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: dump_join_ctl.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: dump_join_ctl.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 08:55:45  keith
** Initial revision
**
*/

/*
** This function is used to assist debugging. It prints contents of the
** join_ctl_t structure.
*/
void dump_join_ctl( join_ctl_t *join, unsigned short join_cnt )
{
	static const char	func[] = "dump_join_ctl";
	unsigned short	ndx, join_ndx;
	map_field_t	*map_field;
	dfile_tag_t	*dfile_tag;

	assert( join != (join_ctl_t *)0 );

	DEBUG_FUNC_START;

	(void) fputs( "join:\n", stderr );

	for ( join_ndx = (unsigned short)0; join_ndx < join_cnt; ++join_ndx ) {

		(void) fprintf( stderr, "\tdfile_name = [%s]\n", join->dfile_name );
		(void) fprintf( stderr, "\tunique_join_flag = [%c] (F)irst/(L)ast\n", join->unique_join_flag );
		(void) fprintf( stderr, "\tinner_outer_join_flag = [%c] (I)nner/(O)outer\n", join->inner_outer_join_flag );

		(void) fputs( "\tcopy field:\n", stderr );
		for ( ndx = (unsigned short)0; ndx < join->copy_field_tbl_cnt; ++ndx ) {
			(void) fprintf( stderr, "\t\t%d. [%s]\n", ndx + 1, join->copy_field_tbl[ ndx ] );
		}

		(void) fputs( "\tkey field:\n", stderr );
		for ( ndx = (unsigned short)0; ndx < join->key_field_tbl_cnt; ++ndx ) {
			(void) fprintf( stderr, "\t\t%d. [%s]\n", ndx + 1, join->key_field_tbl[ ndx ] );
		}

		(void) fputs( "\tmap fields: <direction #1> <direction #2>\n", stderr );
		map_field = join->map_field_tbl;
		for ( ndx = (unsigned short)0; ndx < join->map_field_tbl_cnt; ++ndx ) {
			(void) fprintf( stderr, "\t\t%d. [%s] [%s], [%s] [%s]\n", ndx + 1, map_field->field[ 0 ].direction, map_field->field[ 0 ].field_name, map_field->field[ 1 ].direction, map_field->field[ 1 ].field_name );
			++map_field;
		}

		(void) fprintf( stderr, "\touter join status field = [%s]\n", join->status_field );

		(void) fprintf( stderr, "\trecord_filter = %p\n", join->record_filter );

		(void) fputs( "\tdfile tag: <tag> <tag value>\n", stderr );
		dfile_tag = join->tag;
		for ( ndx = (unsigned short)0; ndx < join->tag_cnt; ++ndx ) {
			(void) fprintf( stderr, "\t\t%d. [%s] [%s]\n", ndx + 1, dfile_tag->tag, dfile_tag->tag_value );
			++dfile_tag;
		}

		(void) fprintf( stderr, "\tblocks_per_buffer_cnt = %hu\n", join->blocks_per_buffer_cnt );
		(void) fprintf( stderr, "\tbuffer_cnt = %hu\n", join->buffer_cnt );
		(void) fprintf( stderr, "\tIPC key = [%s]\n", NULL_CHECK( join->ipc_key ) );

		(void) fputc( '\n', stderr );
		++join;
	}

	RETURN_VOID;
}
