/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_partition.h"

static const char       rcsid[] = "$Id: find_partition.c,v 1.2 2009/10/16 20:16:47 keith Exp $";

/*
** $Log: find_partition.c,v $
** Revision 1.2  2009/10/16 20:16:47  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 20:55:54  keith
** Initial revision
**
*/

/*
** This function does a binary search to locate correct partition. Key value
** is expected to be greater than or equal to minimum partition value from
** divvy table.
*/
int find_partition( unsigned short *partition_ndx, const char *key, const char **divvy_tbl, unsigned short divvy_tbl_cnt )
{
	static const char	func[] = "find_partition";
	const char	**ptr;

	assert( key != (const char *)0 );

	DEBUG_FUNC_START;

	ptr = (const char **)psearch( (const void *)&key, (const void *)divvy_tbl, (size_t)divvy_tbl_cnt, sizeof( const char * ), (int (*)( const void *, const void * ))divvy_cmp );

	if ( ptr == (const char **)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Partition key value [", stderr );
		(void) fputs( key, stderr );
		(void) fputs( "] is less than lowest defined partition partition [", stderr );
		(void) fputs( divvy_tbl[ 0 ], stderr );
		(void) fputs( "].\n", stderr );
		RETURN_INT( -1 );
	}

	assert( ptr >= divvy_tbl );
	assert( ptr < &divvy_tbl[ divvy_tbl_cnt ] );

	*partition_ndx = (unsigned short)( ptr - divvy_tbl );

	if ( Debug ) {
		(void) fprintf( stderr, "partition_ndx = %hu\n", *partition_ndx );
	}

	RETURN_INT( 0 );
}
