/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_partition.h"

static const char       rcsid[] = "$Id: load_range_partition_file.c,v 1.3 2009/10/16 20:16:47 keith Exp $";

/*
** $Log: load_range_partition_file.c,v $
** Revision 1.3  2009/10/16 20:16:47  keith
** Added GPL to source code.
**
** Revision 1.2  2009/03/13 06:33:55  keith
** Needed to add limits.h header file.
**
** Revision 1.1  2009/03/08 21:02:19  keith
** Initial revision
**
*/

/*
** This function load a range partition definition file in to memory.
*/
int load_range_partition_file( const char ***divvy_text, unsigned short *divvy_text_cnt, const char *divvy_fname )
{
	static const char	func[] = "load_range_partition_file";
	unsigned long	divvy_text_cnt_tmp;

	assert( divvy_text != (const char ***)0 );
	assert( divvy_text_cnt != (unsigned short *)0 );
	assert( divvy_fname != (const char *)0 );

	DEBUG_FUNC_START;

	*divvy_text_cnt = (unsigned short)0;
	*divvy_text = (const char **)0;

	divvy_text_cnt_tmp = 0UL;

	if ( load_text_file( divvy_text, &divvy_text_cnt_tmp, divvy_fname ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( divvy_text_cnt_tmp > (unsigned long)USHRT_MAX ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "number of partitions (", stderr );
		(void) fput_ulong( divvy_text_cnt_tmp, stderr );
		(void) fputs( ") exceeded maximum (", stderr );
		(void) fput_ulong( (unsigned long)USHRT_MAX, stderr );
		(void) fputs( ").\n", stderr );

		RETURN_INT( -1 );
	}

	*divvy_text_cnt = (unsigned short)divvy_text_cnt_tmp;

	if ( *divvy_text_cnt == (unsigned short)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Partition definition file was empty.\n", stderr );
		RETURN_INT( -1 );
	}

	if ( *divvy_text_cnt > (unsigned short)50 ) {
		shell_sort( (void *)*divvy_text, (size_t)*divvy_text_cnt, sizeof( const char * ), divvy_cmp );
	} else {
		insertion_sort( (void *)*divvy_text, (size_t)*divvy_text_cnt, sizeof( const char * ), divvy_cmp );
	}

	RETURN_INT( 0 );
}
