/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"
#include "dfile_partition.h"

static const char       rcsid[] = "$Id: map_bind.c,v 1.2 2009/10/16 20:16:47 keith Exp $";

/*
** $Log: map_bind.c,v $
** Revision 1.2  2009/10/16 20:16:47  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 21:14:19  keith
** Initial revision
**
*/

/*
** This function maps input bind to output bind.
*/
int map_bind( dfile_bind_t *output_bind, unsigned short output_bind_cnt, void *input_bind_hash_table )
{
	static const char	func[] = "map_bind";
	dfile_bind_t	**bind_entry, *bind;

	assert( output_bind != (dfile_bind_t *)0 );
	assert( input_bind_hash_table != (void *)0 );

	DEBUG_FUNC_START;

	if ( _dfile_alloc_bind_fields( output_bind, output_bind_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	for ( ; output_bind_cnt > (unsigned short)0; --output_bind_cnt, ++output_bind ) {
		bind_entry = (dfile_bind_t **)dhfind( (void *)output_bind, input_bind_hash_table, strhkey( output_bind->field_name ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			/*
			** Output field does not map to input layout.
			*/
			*output_bind->field_buffer = "";
			*output_bind->field_length = (size_t)0;
			continue;
		}

		bind = *bind_entry;

		output_bind->field_buffer = bind->field_buffer;
		output_bind->field_length = bind->field_length;
	}

	RETURN_INT( 0 );
}
