/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: assign_order_by.c,v 1.3 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: assign_order_by.c,v $
** Revision 1.3  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.2  2009/03/15 13:03:53  keith
** Shift field name to upper case.
**
** Revision 1.1  2009/03/09 11:39:15  keith
** Initial revision
**
*/

/*
** This function assigns information from control structure.
*/
int assign_order_by( order_by_t **ret_order_by, unsigned short *ret_order_by_cnt, sexpr_t *field, unsigned short tuple_cnt )
{
	static const char	func[] = "assign_order_by";
	int	ret;
	order_by_t	*order_by, *new;
	unsigned short	order_by_cnt;
	size_t	alloc_size;
	sexpr_t	*field_attribute;

	assert( ret_order_by != (order_by_t **)0 );
	assert( ret_order_by_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	order_by = (order_by_t *)0;
	order_by_cnt = (unsigned short)0;
	new = (order_by_t *)0;

	while ( field != (sexpr_t *)0 ) {
		alloc_size = sizeof( order_by_t ) * ( (size_t)order_by_cnt + (size_t)1 );
		new = (order_by_t *)realloc( new, alloc_size );
		if ( new == (order_by_t *)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		order_by = &new[ order_by_cnt ];
		++order_by_cnt;

		if ( SEXPR_CAR_TYPE( field ) != list_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a list", tuple_cnt );
			RETURN_INT( -1 );
		}

		field_attribute = SEXPR_CAR_LIST( field );

		if ( SEXPR_CAR_TYPE( field_attribute ) != string_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
			RETURN_INT( -1 );
		}

		order_by->field_name = SEXPR_CAR_STRING( field_attribute );
		strtoupper( order_by->field_name );

		if ( Debug ) {
			fprintf( stderr, "found field [%s]\n", order_by->field_name );
		}

		/*
		** Set default values.
		*/
		order_by->ascend_descend = 'A';
		order_by->value_type = 'A';

		assert( SEXPR_CDR_TYPE( field_attribute ) == list_sexpr );

		ret = assign_field_attribute( order_by, SEXPR_CDR_LIST( field_attribute ), tuple_cnt );
		if ( ret != 0 ) {
			RETURN_INT( ret );
		}

		assert( SEXPR_CDR_TYPE( field ) == list_sexpr );

		field = SEXPR_CDR_LIST( field );
	}

	*ret_order_by = new;
	*ret_order_by_cnt = order_by_cnt;

	RETURN_INT( 0 );
}
