/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: compare_order_by_bind.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: compare_order_by_bind.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/10 03:20:05  keith
** Initial revision
**
*/

/*
** This function compares key fields between two bind structures.
*/
int compare_order_by_bind( dfile_bind_t *lhs_bind, const unsigned short *lhs_key_ndx, dfile_bind_t *rhs_bind, const unsigned short *rhs_key_ndx, const order_by_t *key_tbl, unsigned short key_tbl_cnt )
{
	static const char	func[] = "compare_order_by_bind";
	int	result;
	dfile_bind_t	*lhs, *rhs;

	assert( lhs_bind != (dfile_bind_t *)0 );
	assert( lhs_key_ndx != (unsigned short *)0 );
	assert( rhs_bind != (dfile_bind_t *)0 );
	assert( rhs_key_ndx != (unsigned short *)0 );
	assert( key_tbl != (const order_by_t *)0 );

	DEBUG_FUNC_START;

	for ( ; key_tbl_cnt > (unsigned short)0; --key_tbl_cnt ) {
		lhs = &lhs_bind[ *lhs_key_ndx ];
		rhs = &rhs_bind[ *rhs_key_ndx ];

		result = compare( *lhs->field_buffer, *lhs->field_length, *rhs->field_buffer, *rhs->field_length, key_tbl->value_type, key_tbl->ascend_descend );

		if ( result != 0 ) {
			RETURN_INT( result );
		}

		++lhs_key_ndx;
		++rhs_key_ndx;
		++key_tbl;
	}

	RETURN_INT( 0 );
}
