/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: open_output.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: open_output.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/12 12:51:48  keith
** Initial revision
**
*/

/*
** This function opens a data file for writing.
*/
int open_output( dfile_t **dfile, const char *dfile_name, dfile_tag_t *tag_tbl, unsigned short tag_tbl_cnt, int thread_output_flag, output_t *output )
{
	static const char	func[] = "open_output";
	const unsigned short	thread_buffer_cnt = 3;
	const unsigned short	no_thread_buffer_cnt = 1;
	unsigned short	buffer_cnt, blocks_per_buffer_cnt;
	dfile_cfg_t	cfg;

	assert( dfile != (dfile_t **)0 );

	DEBUG_FUNC_START;

	if ( dfile_name == (const char *)0 ) {
		/*
		** Use control file.
		*/
		dfile_name = output->dfile_name;

		if ( append_tag( &output->tag, &output->tag_cnt, tag_tbl, tag_tbl_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		tag_tbl = output->tag;
		tag_tbl_cnt = output->tag_cnt;

		blocks_per_buffer_cnt = output->blocks_per_buffer_cnt;
		buffer_cnt = output->buffer_cnt;
	} else {
		/*
		** Use command line.
		*/
		blocks_per_buffer_cnt = (unsigned short)4;
		buffer_cnt = ( thread_output_flag ) ? thread_buffer_cnt : no_thread_buffer_cnt ;
	}

	*dfile = (dfile_t *)0;

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	*dfile = dfile_write_open( &cfg, (dfile_bind_t *)0, (unsigned short)0, tag_tbl, tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt, Dfile_trunc );
	if ( *dfile == (dfile_t *)0 ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
