/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_unique.h"

static const char       rcsid[] = "$Id: copy_record_to_bind.c,v 1.3 2009/10/16 20:26:12 keith Exp $";

/*
** $Log: copy_record_to_bind.c,v $
** Revision 1.3  2009/10/16 20:26:12  keith
** Added GPL to source code.
**
** Revision 1.2  2009/03/13 06:42:00  keith
** Added limits.h header file.
**
** Revision 1.1  2009/03/12 17:27:46  keith
** Initial revision
**
*/

/*
** This function copies a stored record to a bind structure.
*/
void copy_record_to_bind( dfile_bind_t *bind, field_t *rec, const unsigned short *field_ndx_tbl, unsigned short field_ndx_tbl_cnt )
{
	static const char	func[] = "copy_record_to_bind";
	unsigned short	ndx;
	field_t		*field_ptr;

	assert( bind != (dfile_bind_t *)0 );
	assert( rec != (field_t *)0 );
	assert( field_ndx_tbl != (const unsigned short *)0 );

	DEBUG_FUNC_START;

	for ( ; field_ndx_tbl_cnt > (unsigned short)0; --field_ndx_tbl_cnt ) {
		ndx = *field_ndx_tbl;
		if ( ndx == USHRT_MAX ) {
			*bind->field_buffer = "";
			*bind->field_length = (size_t)0;
		} else {
			field_ptr = &rec[ ndx ];
			*bind->field_buffer = field_ptr->value;
			*bind->field_length = field_ptr->length;
		}
		++bind;
		++field_ndx_tbl;
	}

	RETURN_VOID;
}
