/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_construct.c,v 1.3 2009/10/16 07:35:53 keith Exp $";

/*
** $Log: _dfile_construct.c,v $
** Revision 1.3  2009/10/16 07:35:53  keith
** Add GPL to source code.
**
** Revision 1.2  2009/05/21 05:13:04  keith
** Made changes to use DFILE_THREAD as compile time switch for threading.
**
** Revision 1.1  2009/02/21 22:31:26  keith
** Initial revision
**
*/

/*
** This function constructs the dfile_t structure.
*/

dfile_t *_dfile_construct( const dfile_cfg_t *cfg, const dfile_bind_t *bind, unsigned short bind_cnt, const dfile_tag_t *tag, unsigned short tag_cnt, unsigned short buffer_block_cnt, unsigned short buffer_cnt, const dfile_state_t *state_tbl )
{
	static const char	func[] = "_dfile_construct";
	dfile_t	*dfile;

	DEBUG_FUNC_START;

	/*
	** Create DFile structure.
	*/
	dfile = (dfile_t *)malloc( sizeof( dfile_t ) );
	if ( dfile == (dfile_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_POINTER( (dfile_t *)0 );
	}

	/*
	** Populate DFile structure.
	*/
	(void) memset( (void *)dfile, 0, sizeof( dfile_t ) );

	dfile->dfile_name = cfg->dfile_name;

	dfile->rec_attribute = cfg->rec_attribute;

	dfile->file_name = _dfile_sub_tags( cfg->data_file_path, tag, tag_cnt );
	if ( dfile->file_name == (const char *)0 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

	dfile->bind_cnt = cfg->bind_cnt;
	dfile->bind = cfg->bind;

	if ( _dfile_alloc_bind_fields( dfile->bind, dfile->bind_cnt ) == -1 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

	dfile->bind_hash_table = cfg->bind_hash_table;

	if ( _dfile_bind( dfile->bind, dfile->bind_cnt, bind, bind_cnt, dfile->bind_hash_table ) == -1 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

#ifdef DFILE_THREAD
	dfile->buffer_cnt = buffer_cnt;
#endif

	dfile->buffer_base = _dfile_create_buffers( buffer_cnt, state_tbl );
	if ( dfile->buffer_base == (dfile_buffer_t *)0 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

	dfile->io_buffer = dfile->buffer_base;
	dfile->application_buffer = dfile->buffer_base;
	dfile->open_descriptor = -1;
	dfile->error = Dfile_ok;
	dfile->buffer_block_cnt = buffer_block_cnt;
	dfile->format = _dfile_identify_format( dfile->file_name );

	RETURN_POINTER( dfile );
}
