/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_copy_field_to_buffer.c,v 1.2 2009/10/16 07:35:53 keith Exp $";

/*
** $Log: _dfile_copy_field_to_buffer.c,v $
** Revision 1.2  2009/10/16 07:35:53  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/22 07:24:31  keith
** Initial revision
**
*/

/*
** This function copies a field value to the writing buffer.
*/

int _dfile_copy_field_to_buffer( dfile_t *dfile, const char *value, const size_t *length )
{
	static const char	func[] = "_dfile_copy_field_to_buffer";
	int	ret;
	size_t	remaining_length;
	dfile_buffer_t	*buffer;

	assert( dfile != (dfile_t *)0 );
	assert( value != (const char *)0 );

	DEBUG_FUNC_START;

	buffer = dfile->application_buffer;
	assert( buffer != (dfile_buffer_t *)0 );

	if ( length == (size_t *)0 ) {
		ret = ( *dfile->format_str_func )( &buffer->buf_ptr, buffer->buf_ptr_end, &value, dfile->rec_attribute );
	} else {
		remaining_length = *length;
		ret = ( *dfile->format_func )( &buffer->buf_ptr, buffer->buf_ptr_end, &value, &remaining_length, dfile->rec_attribute );
	}

	while ( ret == -1 ) {
		if ( _dfile_advance_buffer( dfile, buffer ) == -1 ) {
			RETURN_INT( -1 );
		}
		buffer = dfile->application_buffer;

		if ( length == (size_t *)0 ) {
			ret = ( *dfile->format_str_func )( &buffer->buf_ptr, buffer->buf_ptr_end, &value, dfile->rec_attribute );
		} else {
			ret = ( *dfile->format_func )( &buffer->buf_ptr, buffer->buf_ptr_end, &value, &remaining_length, dfile->rec_attribute );
		}
	}

	RETURN_INT( 0 );
}
