/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_flush_ascii_buffer.c,v 1.2 2009/10/16 07:35:54 keith Exp $";

/*
** $Log: _dfile_flush_ascii_buffer.c,v $
** Revision 1.2  2009/10/16 07:35:54  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/22 15:10:17  keith
** Initial revision
**
*/

/*
** This function writes an ASCII buffer to disk.
*/

int _dfile_flush_ascii_buffer( dfile_t *dfile )
{
	static const char	func[] = "_dfile_flush_ascii_buffer";
	ssize_t	write_cnt;
	size_t	available_cnt;
	dfile_buffer_t	*buffer;
	const char	*buf_ptr_end, *buf_ptr;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	buffer = dfile->io_buffer;
	assert( buffer != (dfile_buffer_t *)0 );
	assert( buffer->buf_ptr >= buffer->buffer_area );
	buf_ptr_end = buffer->buf_ptr;
	buf_ptr = buffer->buffer_area;

	while ( buf_ptr < buf_ptr_end ) {
		available_cnt = (size_t)( buf_ptr_end - buf_ptr );

		write_cnt = write( dfile->open_descriptor, buf_ptr, available_cnt );
		if ( write_cnt < 0 ) {
			UNIX_ERROR( "write() failed" );
			dfile->error = Dfile_io_failed;
			RETURN_INT( -1 );
		}

		buf_ptr = &buf_ptr[ write_cnt ];
	}

	buffer->buf_ptr = buffer->buffer_area;
	buffer->buffer_rec_cnt = 0UL;

	RETURN_INT( 0 );
}
