/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_free.c,v 1.2 2009/10/16 07:35:54 keith Exp $";

/*
** $Log: _dfile_free.c,v $
** Revision 1.2  2009/10/16 07:35:54  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/22 22:39:26  keith
** Initial revision
**
*/

/*
** This function free memory allocated for the dfile_t structure.
*/

void _dfile_free( dfile_t *dfile )
{
	static const char	func[] = "_dfile_free";
	dfile_buffer_t	*buffer;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	assert( dfile->buffer_base != (dfile_buffer_t *)0 );
	buffer = dfile->buffer_base;

	do {
		assert( buffer != (dfile_buffer_t *)0 );
		if ( buffer->buffer_area != (char *)0 ) {
			free( (void *)buffer->buffer_area );
		}
		buffer = buffer->next;
	} while ( buffer != dfile->buffer_base );

	if ( dfile->zipped_buffer != (unsigned char *)0 ) {
		free( (void *)dfile->zipped_buffer );
	}

	if ( dfile->zstream != (void *)0 ) {
		free( dfile->zstream );
	}

	if ( dfile->bind != (dfile_bind_t *)0 ) {
		free( (void *)dfile->bind );
	}

	free( (void *)dfile->buffer_base );

	if ( dfile->overflow != (char *)0 ) {
		free( (void *)dfile->overflow );
	}

	free( (void *)dfile );

	RETURN_VOID;
}
