/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_overflow.c,v 1.2 2009/10/16 07:35:55 keith Exp $";

/*
** $Log: _dfile_overflow.c,v $
** Revision 1.2  2009/10/16 07:35:55  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/25 07:59:38  keith
** Initial revision
**
*/

/*
** This function finds the beginning of the last record fragment in buffer.
*/

int _dfile_overflow( const char **buf_ptr_end, const char *buffer, size_t buffer_len, dfile_rec_t rec )
{
	static const char	func[] = "_dfile_overflow";
	register const char	*ptr;

	assert( buf_ptr_end != (const char **)0 );
	assert( buffer != (const char *)0 );

	DEBUG_FUNC_START;

	ptr = &buffer[ buffer_len ];
	*buf_ptr_end = (char *)0;

	while ( --ptr >= buffer ) {
		if ( *ptr == rec.record_separator ) {
			/*
			** End of record.
			*/
			*buf_ptr_end = &ptr[ 1 ];

			RETURN_INT( 0 );
		}
	}

	/*
	** Start of buffer encountered.
	*/

	RETURN_INT( -1 );
}
