/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_parse_field.c,v 1.2 2009/10/16 07:35:55 keith Exp $";

/*
** $Log: _dfile_parse_field.c,v $
** Revision 1.2  2009/10/16 07:35:55  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/26 02:19:13  keith
** Initial revision
**
*/

/*
** This function parses a field from a record. It assumes field and record
** separator characters are not embedded in data. Special separator
** characters are removed during parsing.
*/

dfile_parse_t _dfile_parse_field( char **buf_ptr, size_t *length, dfile_rec_t rec_attribute )
{
	register char	*ptr;
	register char	record_separator, field_separator;

	assert( buf_ptr != (char **)0 );
	assert( *buf_ptr != (char *)0 );

	ptr = *buf_ptr;
	record_separator = rec_attribute.record_separator;
	field_separator = rec_attribute.field_separator;

	assert( ptr != (char *)0 );

	for ( ;; ) {
		if ( *ptr == field_separator ) {
			/*
			** Replace separator character with null.
			*/
			*ptr = (char)0;
			assert( ptr >= *buf_ptr );
			*length = (size_t)( ptr - *buf_ptr );
			*buf_ptr = &ptr[ 1 ];
			return Dfile_parsed_field;
		}

		if ( *ptr == record_separator ) {
			/*
			** Replace separator character with null.
			*/
			*ptr = (char)0;
			assert( ptr >= *buf_ptr );
			*length = (size_t)( ptr - *buf_ptr );
			*buf_ptr = &ptr[ 1 ];
			return Dfile_parsed_record;
		}
		++ptr;
	}

	/*
	** Should never reach this point.
	*/
	abort();
}
