/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_parse_record_failure.c,v 1.3 2009/10/16 07:35:55 keith Exp $";

/*
** $Log: _dfile_parse_record_failure.c,v $
** Revision 1.3  2009/10/16 07:35:55  keith
** Add GPL to source code.
**
** Revision 1.2  2009/02/26 08:54:46  keith
** Changed fput_src_code to macro FPUT_SRC_CODE.
**
** Revision 1.1  2009/02/26 03:49:48  keith
** Initial revision
**
*/

/*
** This is the default function called when a delimited record has incorrect
** number of fields. Calling program can choose to replace this function.
** Returning zero causes parsing to continue. Returing -1 causes library to
** return failure.
*/

int _dfile_parse_record_failure( dfile_t *dfile, unsigned short parse_field_cnt )
{
	static const char	func[] = "_dfile_parse_record_failure";

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	FPUT_SRC_CODE( stderr );
	(void) fputs( "File [", stderr );
	(void) fputs( dfile->file_name, stderr );
	(void) fputs( "], record ", stderr );
	(void) fput_ulong( dfile->file_rec_cnt, stderr );
	(void) fputs( ", contained ", stderr );
	(void) fput_ushort( parse_field_cnt, stderr );
	(void) fputs( " fields--expected ", stderr );
	(void) fput_ushort( dfile->bind_cnt, stderr );
	(void) fputs( " fields.\n", stderr );

	RETURN_INT( -1 );
}
