/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_release_buffer.c,v 1.3 2009/10/16 07:35:56 keith Exp $";

/*
** $Log: _dfile_release_buffer.c,v $
** Revision 1.3  2009/10/16 07:35:56  keith
** Add GPL to source code.
**
** Revision 1.2  2009/05/21 20:58:39  keith
** Made changes to use DFILE_THREAD as compile time switch for threading.
**
** Revision 1.1  2009/02/28 03:03:17  keith
** Initial revision
**
*/

#ifdef DFILE_THREAD

/*
** This function rotates and unlocks a buffer.
*/

int _dfile_release_buffer( dfile_buffer_t *buffer )
{
	static const char	func[] = "_dfile_release_buffer";
	int	ret;

	assert( buffer != (dfile_buffer_t *)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "Thread %u released buffer %hu.\n", pthread_self(), buffer->buffer_id );
	}

	buffer->state = buffer->state->next;

	buffer->thread_id = (pthread_t)0;
	ret = pthread_mutex_unlock( &buffer->mutex );
	if ( ret != 0 ) {
		THREAD_ERROR( "pthread_mutex_unlock() failed", ret );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
#endif
