/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_var_record_append_overflow.c,v 1.2 2009/10/16 07:35:57 keith Exp $";

/*
** $Log: _dfile_var_record_append_overflow.c,v $
** Revision 1.2  2009/10/16 07:35:57  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/28 05:32:39  keith
** Initial revision
**
*/

/*
** This function appends rest of record to overflow area. This record
** fragment was found at beginning of next buffer.
*/
void _dfile_var_record_append_overflow( dfile_t *dfile )
{
	static const char	func[] = "_dfile_var_record_append_overflow";
	char	*overflow;
	size_t	overflow_size, new_overflow_length, overflow_length;
	size_t	append_overflow_len;
	dfile_bind_t	*bind;
	dfile_buffer_t	*buffer;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	append_overflow_len = dfile->read_var_rec.append_overflow_len;

	bind = dfile->read_var_rec.current_bind;
	assert( bind != (dfile_bind_t *)0 );

	buffer = dfile->application_buffer;
	assert( buffer != (dfile_buffer_t *)0 );

	overflow_length = dfile->overflow_length;

	overflow_size = dfile->overflow_size;
	overflow = dfile->overflow;

	if ( append_overflow_len == (size_t)0 ) {
		overflow[ overflow_length ] = (char)0;
		RETURN_VOID;
	}

	new_overflow_length = overflow_length + append_overflow_len;

	assert( overflow_size > new_overflow_length );
	assert( buffer->buf_ptr_end >= buffer->buf_ptr );

	assert( ( buffer->buf_ptr_end - buffer->buf_ptr ) >= append_overflow_len );

	(void) memcpy( &overflow[ overflow_length ], buffer->buf_ptr, append_overflow_len );
	overflow[ new_overflow_length ] = (char)0;

	buffer->buf_ptr += append_overflow_len;
	++dfile->read_var_rec.processed_field_cnt;

	RETURN_VOID;
}
