/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <assert.h>
#include "tbox.h"

static const char       rcsid[] = "$Id: strhkey.c,v 1.2 2009/10/16 18:00:43 keith Exp $";

/*
** $Log: strhkey.c,v $
** Revision 1.2  2009/10/16 18:00:43  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/14 21:40:42  keith
** Initial revision
**
*/

static unsigned long hash_calc( unsigned long, char );

unsigned long strhkey( const char *str )
{
	static const char	end_msg[] = "End %s() returning %lu at %s\n";
	static const char	func[] = "strhkey";
	unsigned long	h = 0;

	assert( str != (const char *)0 );

	if ( Debug ) {
		(void) fprintf( stderr, "%s( [%s] )\n", func, str );
		(void) fprintf( stderr, "%s() started at %s\n", func, get_ctime() );
	}

	for ( ; *str != (char)0; ++str ) {
		h = hash_calc( h, *str );
	}

	if ( Debug ) {
		(void) fprintf( stderr, end_msg, func, h, get_ctime() );
	}

	return h;
}

unsigned long aschkey( const char *ptr, size_t len, unsigned long h )
{
	static const char	end_msg[] = "End %s() returning %lu at %s\n";
	static const char	func[] = "aschkey";

	assert( ptr != (const char *)0 );

	if ( Debug ) {
		(void) fprintf( stderr, "%s( [%*.*s], %u, %lu )\n", func, len, len, ptr, len, h );
		(void) fprintf( stderr, "%s() started at %s\n", func, get_ctime() );
	}

	for ( ; len > (size_t)0; --len, ++ptr ) {
		h = hash_calc( h, *ptr );
	}

	if ( Debug ) {
		(void) fprintf( stderr, end_msg, func, h, get_ctime() );
	}

	return h;
}

/*
** This function was suggested in "Compilers: Principles, Techniques,
** and Tools" by Aho, Sethi and Ullman as a good algorithm to generate
** hash keys from ASCII text strings. They had borrowed it from P. J.
** Weinberger's C compiler.
*/

static unsigned long hash_calc( register unsigned long h, char ch )
{
	register unsigned long	g;

	h = ( h << 4 ) + (unsigned long)ch;
	g = h & 0xf0000000;
	if ( g != 0UL ) {
		h ^= g >> 24;
		h ^= g;
	}

	return h;
}
