/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#define _THREAD_SAFE
#define _THREAD_SAFE_ERRNO
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include "tbox.h"

static const char       rcsid[] = "$Id: unix_error.c,v 1.2 2009/10/16 18:00:43 keith Exp $";

/*
** $Log: unix_error.c,v $
** Revision 1.2  2009/10/16 18:00:43  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/15 03:44:45  keith
** Initial revision
**
*/

/*
** This function prints a UNIX error message.
*/
void unix_error( const char *user_msg, const char *module, int line )

{
	static const char	func[] = "unix_error";
	const char	*display_time, *unix_msg;
	int	error_code;

	assert( user_msg != (char *) 0 );
	assert( module != (char *) 0 );
	assert( line > 0 );

	/*
	** Save error code value before it is reset.
	*/
	error_code = errno;

	if ( Debug ) {
		(void) fprintf( stderr, "Start %s()\n", func );
	}

	if ( ( display_time = fmt_ctime() ) == (char *) 0 ) {
		display_time = "UNKNOWN TIME";
	}

	if ( ( unix_msg = strerror( error_code ) ) == (char *) 0 ) {
		unix_msg = "ERROR MESSAGE WAS NOT FOUND";
	}

	(void) fputs( display_time, stderr );
	(void) fputc( ' ', stderr );
	(void) fputs( module, stderr );
	(void) fputc( '(', stderr );
	(void) fprintf( stderr, "%d", line );
	(void) fputs( "): ", stderr );
	(void) fputs( user_msg, stderr );
	(void) fputs( "\n   + ** UNIX ERROR ", stderr );
	(void) fprintf( stderr, "%d", error_code );
	(void) fputs( " **, ", stderr );
	(void) fputs( unix_msg, stderr );
	(void) fputc( '\n', stderr );

	if ( Debug ) {
		(void) fprintf( stderr, "End %s() returning no value\n", func );
	}
}

#ifdef MT_unix_error

#include <stdlib.h>
/*
** This function is used to regression test unix_error().
** The following command is used to compile:
**   x=unix_error; make "MT_CC=-DMT_$x" "MT_PRE=DEFINE=MT_$x" $x
*/
int main( void )

{
	static const char	complete_msg[] =  ">>> Module test on function %s() is complete.\n";
	static const char	test_func[] = "unix_error";
	static const char	blank_line[] = ">>>\n";

	Debug = 1;

	(void) fprintf( stderr, ">>> Start module test on function %s().\n", test_func );
	(void) fputs( blank_line, stderr );
	(void) fputs( ">>> TEST CASE #1\n", stderr );
	(void) fputs( ">>> Check failure for incorrect errno value.\n", stderr );
	(void) fputs( blank_line, stderr );

	errno = 10000;
	unix_error( "errno value 10,000", __FILE__, __LINE__ );

	(void) fputs( blank_line, stderr );
	(void) fputs( ">>> TEST CASE #2\n", stderr );
	(void) fputs( ">>> Check failure for good errno value.\n", stderr );
	(void) fputs( blank_line, stderr );

	errno = 0;
	unix_error( "errno value 0", __FILE__, __LINE__ );

	(void) fputs( blank_line, stderr );
	(void) fputs( ">>> TEST CASE #3\n", stderr );
	(void) fputs( ">>> Check correct response to failed write().\n", stderr );
	(void) fputs( blank_line, stderr );

	(void) write( -5, "hello", 5 );
	unix_error( "failed write()", __FILE__, __LINE__ );

	(void) fputs( blank_line, stderr );
	(void) fprintf( stderr, complete_msg, test_func );
	exit( 0 );
}
#endif
