/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "where.h"

static const char       rcsid[] = "$Id: where_error.c,v 1.2 2009/10/16 17:27:11 keith Exp $";

/*
** $Log: where_error.c,v $
** Revision 1.2  2009/10/16 17:27:11  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/18 06:22:40  keith
** Initial revision
**
*/

/*
** This function formats an error message.
*/

const char *where_error( int where_errno )
{
	static const char func[] = "where_error";
	static const char	unknown_msg[] = "unknown error";
	const char	*ret;

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "error code %d\n", where_errno );
	}

	if ( where_errno < 0 ) {
		/*
		** UNIX error
		*/
		ret = strerror( errno );
	} else {
		/*
		** where error
		*/
		if ( where_errno >= Where_err_msg_cnt ) {
			ret = unknown_msg;
		} else {
			ret = Where_err_msg[ where_errno ];
		}
	}

	RETURN_POINTER( ret );
}
